INPUT_PORT = 0
OUTPUT_PORT = 1
POLARITY_PORT = 2
CONFIG_PORT = 3
    
class TCA9534(object):

    def __init__(self, i2c, address):
        self.i2c = i2c;
        self.address = address
    #read the 16-bit value of register
    def getReg(self, register):
        self.i2c.writeto(self.address,register)
        return self.i2c.readfrom(self.address,1)[0]
    # Write the register to value
    def setReg(self, register, value):
        self.i2c.writeto(self.address, chr(register)+chr(value&0xff))
    # Get a 8-bit value with the input values
    def readIn(self):
        return self.getReg(INPUT_PORT)
    #Get a 8-bit value with the output values
    def readOut(self):
        return self.getReg(OUTPUT_PORT)
    #Write a 8-bit value to the output port
    def writeOut(self,value):
        self.setReg(OUTPUT_PORT,value)
    #set a mask in the output port to high
    def setOutHigh(self, value):
        d=self.getReg(OUTPUT_PORT)
        d=d|value
        self.setReg(OUTPUT_PORT,d)
    #set a mask in the output port to low
    def setOutLow(self,value):
        d=self.getReg(OUTPUT_PORT)
        d=d & ~value
        self.setReg(OUTPUT_PORT,d)
    #read the port polarity register (should be 0x0000 unless someone f***ed up)
    def readPolarity(self):
        return self.getReg(POLARITY_PORT)
    #write the port polarity register (really... why use it???)
    def writePolarity(self,value):
        self.setReg(POLARITY_PORT,value)
    #get a 8-bit value of the direction. NB:1 is in and 0 is out. Strange no?
    #Contact Texas Instruments and ask them why
    def readDirection(self):
        return self.getReg(CONFIG_PORT)
    #write a 8-bit value to the direction register. Also read the 0-1 thingy at readDirection
    def writeDirection(self,value):
        self.setReg(CONFIG_PORT,value)