INPUT_PORT = 0
OUTPUT_PORT = 1
POLARITY_PORT = 2
CONFIG_PORT = 3
    
class GPIO(object):

    def __init__(self, i2c, address):
        self.i2c = i2c;
        self.address = address
#        self.tempBuff=bytearray(3)
    #read the 16-bit value of register
    def getReg(self, register):
        self.i2c.writeto(self.address,register)
        d=self.i2c.readfrom(self.address,2)
        return (d[1]<<8)|d[0]
    # Write the register to value
    def setReg(self, register, value):
        buff=bytearray(3)
        buff[0]=register
        buff[1]=value&0xff
        buff[2]=(value>>8)&0xff
        self.i2c.writeto(self.address, buff)
    # Get a 16-bit value with the input values
    def readIn(self):
        return self.getReg(INPUT_PORT<<1)
    #Get a 16-bit value with the output values
    def readOut(self):
        return self.getReg(OUTPUT_PORT<<1)
    #Write a 16-bit value to the output port
    def writeOut(self,value):
        self.setReg(OUTPUT_PORT<<1,value)
    #set a mask in the output port to high
    def setOutHigh(self, value):
        d=self.getReg(OUTPUT_PORT<<1)
        d=d|value
        self.setReg(OUTPUT_PORT<<1,d)
    #set a mask in the output port to low
    def setOutLow(self,value):
        d=self.getReg(OUTPUT_PORT<<1)
        d=d & ~value
        self.setReg(OUTPUT_PORT<<1,d)
    #read the port polarity register (should be 0x0000 unless someone f***ed up)
    def readPolarity(self):
        return self.getReg(POLARITY_PORT<<1)
    #write the port polarity register (really... why use it???)
    def writePolarity(self,value):
        self.setReg(POLARITY_PORT<<1,value)
    #get a 16-bit value of the direction. NB:1 is in and 0 is out. Strange no?
    #Contact Texas Instruments and ask them why
    def readDirection(self):
        return self.getReg(CONFIG_PORT<<1)
    #write a 16-bit value to the direction register. Also read the 0-1 thingy at readDirection
    def writeDirection(self,value):
        self.setReg(CONFIG_PORT<<1,value)