#00-SOIL
RD_STS_3LMT=    b'\x02\x03\x00\x00\x00\x06\xc5\xfb'#$02$03$00$00$00$06$c5$fb
RD_SCO2R_01=    b'\x03\x03\x00\x00\x00\x01\x85\xe8'#$03$03$00$00$00$01$85$e8
RD_SPHAG_RD=    b'\x04\x03\x00\x00\x00\x03\x05\x9e'#$04$03$00$00$00$03$05$9e
RD_SCH2H4R_01=  b'\x06\x03\x00\x00\x00\x01\x85\xbd'#$06$03$00$00$00$01$85$bd
RD_S7=          b'\x07\x03\x00\x00\x00\x07\x04\x6e'#$07$03$00$00$00$07$04$6e
RD_S8IN1=       b'\x08\x03\x00\x00\x00\x08\x44\x95'#$08$03$00$00$00$08$44$95
RD_S4=          b'\x09\x03\x00\x00\x00\x04\x45\x41'#$09$03$00$00$00$04$45$41
RD_ALLSOIL_INIT=b'\x0A\x06\x00\x00\x00\x7F\xC9\x51'#$0A$06$00$00$00$7F$C9$51
RD_ALLSOIL_SLP= b'\x0A\x06\x00\x00\x00\x80\x89\x11'#$0A$06$00$00$00$80$89$11
RD_ALLSOIL_RD=  b'\x0A\x03\x00\x00\x00\x18\x44\xBB'#$0a$03$00$00$00$18$44$bb

#10-SUN
RD_PAS_01=      b'\x13\x03\x00\x00\x00\x01\x87\x78'
RD_TSR_02=      b'\x14\x03\x00\x00\x00\x01\x86\xcf'
RD_UVS_01=      b'\x15\x03\x00\x00\x00\x03\x06\xdf'
RD_W_O_01=      b'\x16\x03\x00\x00\x00\x01\x87\x2d'
RD_PSR_01=      b'\x17\x03\x00\x00\x00\x01\x86\xfc'

#20-WATER
RD_WPSP01_1=    b'\x21\x03\x00\x04\x00\x01\xC2\xAB'
RD_WPSP01_2=    b'\x22\x03\x00\x04\x00\x01\xC2\x98'
RD_WPH_IT=      b'\x23\x03\x00\x00\x00\x01\x82\x88'
RD_UWLDH3_01=   b'\x24\x03\x00\x03\x00\x01\x73\x3f'

#30-AIR
RD_AOTCNN4IN1=  b'\x31\x03\x00\x02\x00\x05\x21\xF9'
RD_AOCNOS4IN1=  b'\x32\x03\x00\x07\x00\x04\xf0\x0b' #in manual e RD-AQ4IN1
RD_WSM_ASA=     b'\x33\x03\x00\x00\x00\x01\x80\x18'
RD_WDM_ASA=     b'\x34\x03\x00\x01\x00\x01\xd0\x6f'
RD_LTH_01=      b'\x35\x03\x00\x00\x00\x02\xc0\x7f'

#40 - VALVES
#valve1=41, valve2=42... valve8=48
import machine
class sensors_485(object):
    def __init__(self):
        return
    def calc_16bit(self,value,pos):
        try:
            return (value[pos]<<8)|value[pos+1]
        except:
            return 0
    def print_hex(self,value):
        print(" ".join(hex(n) for n in value))
#00-SOIL
    def rdsts3lmt(self,resp,to_send):
        to_send["soil_hum0"]  =self.calc_16bit(resp,3)/10
        to_send["soil_temp0"] =self.calc_16bit(resp,5)/10
        to_send["soil_hum1"]  =self.calc_16bit(resp,7)/10
        to_send["soil_temp1"] =self.calc_16bit(resp,9)/10
        to_send["soil_hum2"]  =self.calc_16bit(resp,11)/10
        to_send["soil_temp2"] =self.calc_16bit(resp,13)/10
        return to_send
    def rdsco2r01(self,resp,to_send):
        to_send["soil_coo"]  =self.calc_16bit(resp,3)
        return to_send
    def rdsphagrd(self,resp,to_send):
        to_send["soil_ph"]  =self.calc_16bit(resp,3)/100
        to_send["soil_ph_temp"]  =self.calc_16bit(resp,7)/10
        return to_send
    def rdsch2h4r(self,resp,to_send):
        to_send["soil_c2h4"]  =self.calc_16bit(resp,3)
        return to_send
    def rds4(self,resp,to_send):
        temp=self.calc_16bit(resp,3)
        if temp:
            to_send["soil_humidity"]    =temp/10
        temp=self.calc_16bit(resp,5)
        if temp:
            to_send["soil_temperature"] =temp/100
        temp=self.calc_16bit(resp,7)
        if temp:
            to_send["soil_ec"] =temp
        temp=self.calc_16bit(resp,9)
        if temp:
            to_send["soil_salinity"] =temp
        return to_send
    def rds7(self,resp,to_send):
        temp=self.calc_16bit(resp,3)
        if temp:
            to_send["soil_temperature"]    =temp/10
        temp=self.calc_16bit(resp,5)
        if temp:
            to_send["soil_humidity"] =temp/10
        temp=self.calc_16bit(resp,7)
        if temp:
            to_send["soil_ec"] =temp
        temp=self.calc_16bit(resp,9)
        if temp:
            to_send["soil_salinity"] =temp
        temp=self.calc_16bit(resp,11)
        if temp:
            to_send["soil_n"] =temp
        temp=self.calc_16bit(resp,13)
        if temp:
            to_send["soil_p"] =temp
        temp=self.calc_16bit(resp,15)
        if temp:
            to_send["soil_k"] =temp
        return to_send
    def rds8in1(self,resp,to_send):
        temp=self.calc_16bit(resp,3)
        if temp:
            to_send["soil_humidity"]    =temp/10
        temp=self.calc_16bit(resp,5)
        if temp:
            to_send["soil_temperature"] =temp/10
        temp=self.calc_16bit(resp,7)
        if temp:
            to_send["soil_ec"] =temp
        temp=self.calc_16bit(resp,9)
        if temp:
            to_send["soil_ph"] =temp/10
        temp=self.calc_16bit(resp,11)
        if temp:
            to_send["soil_n"] =temp
        temp=self.calc_16bit(resp,13)
        if temp:
            to_send["soil_p"] =temp
        temp=self.calc_16bit(resp,15)
        if temp:
            to_send["soil_k"] =temp
        temp=self.calc_16bit(resp,17)
        if temp:
            to_send["soil_salinity"] =temp
        return to_send
    def rdallsoil(self,resp,to_send):
        temp=self.calc_16bit(resp,5)
        if temp:
            to_send["soil_hum0"]    =temp/10
        temp=self.calc_16bit(resp,7)
        if temp:
            to_send["soil_temp0"] =temp/10
        temp=self.calc_16bit(resp,9)
        if temp:
            to_send["soil_ec0"] =temp/1000
        temp=self.calc_16bit(resp,11)
        if temp:
            to_send["soil_hum1"]    =temp/10
        temp=self.calc_16bit(resp,13)
        if temp:
            to_send["soil_temp1"] =temp/10
        temp=self.calc_16bit(resp,15)
        if temp:
            to_send["soil_ec1"] =temp/1000
        temp=self.calc_16bit(resp,17)
        if temp:
            to_send["soil_hum2"]    =temp/10
        temp=self.calc_16bit(resp,19)
        if temp:
            to_send["soil_temp2"] =temp/10
        temp=self.calc_16bit(resp,21)
        if temp:
            to_send["soil_ec2"] =temp/1000
        temp=self.calc_16bit(resp,23)
        if temp:
            to_send["soil_hum3"]    =temp/10
        temp=self.calc_16bit(resp,25)
        if temp:
            to_send["soil_temp3"] =temp/10
        temp=self.calc_16bit(resp,27)
        if temp:
            to_send["soil_ec3"] =temp/1000
        temp=self.calc_16bit(resp,29)
        if temp:
            to_send["soil_hum4"]    =temp/10
        temp=self.calc_16bit(resp,31)
        if temp:
            to_send["soil_temp4"] =temp/10
        temp=self.calc_16bit(resp,33)
        if temp:
            to_send["soil_ec4"] =temp/1000
        temp=self.calc_16bit(resp,35)
        if temp:
            to_send["soil_hum5"]    =temp/10
        temp=self.calc_16bit(resp,37)
        if temp:
            to_send["soil_temp5"] =temp/10
        temp=self.calc_16bit(resp,39)
        if temp:
            to_send["soil_ec5"] =temp/1000
        return to_send
#10-SUN        
    def rdpas01(self,resp,to_send):
        to_send["sun_pas"]  =self.calc_16bit(resp,3)
        return to_send
    def rdtsr02(self,resp,to_send):
        to_send["sun_tsr"]  =self.calc_16bit(resp,3)
        return to_send
    def rduvs01(self,resp,to_send):
        to_send["sun_uvr"]  =self.calc_16bit(resp,3)/100
        to_send["sun_uvri"] =self.calc_16bit(resp,5)
        to_send["sun_uvrl"] =self.calc_16bit(resp,7)
        return to_send
    def rdwo01(self,resp,to_send):
        to_send["sun_ill"]  =self.calc_16bit(resp,3)*10
        return to_send
    def rdpsr01(self,resp,to_send):
        to_send["sun_per"]  =self.calc_16bit(resp,3)*10
        return to_send
#10-WATER
    def rdwpsp011(self,resp,to_send):
        to_send["water_pres1"]  =self.calc_16bit(resp,3)/1000
        return to_send
    def rdwpsp012(self,resp,to_send):
        to_send["water_pres2"]  =self.calc_16bit(resp,3)/1000
        return to_send
    def rdwphit(self,resp,to_send):
        to_send["water_ph"]  =self.calc_16bit(resp,3)/100
        return to_send
    def rduwldh301(self,resp,to_send):
        to_send["water_level"]  =self.calc_16bit(resp,3)/1000
        return to_send
 #30-AIR
    def aotcnn4in1(self,resp,to_send):
        to_send["air_co"]  =self.calc_16bit(resp,3)/100
        to_send["air_no"] =self.calc_16bit(resp,5)/1000
        to_send["air_noise"] =self.calc_16bit(resp,9)/10
        to_send["air_tvoc"] =self.calc_16bit(resp,11)
        return to_send
    def aocnos4in1(self,resp,to_send):
        to_send["air_coo"]  =self.calc_16bit(resp,3)
        to_send["air_ooo"] =self.calc_16bit(resp,5)/1000
        to_send["air_noo"] =self.calc_16bit(resp,7)/1000
        to_send["air_soo"] =self.calc_16bit(resp,9)/1000
        return to_send
    def rdwsmasa(self,resp,to_send):
        to_send["air_windspeed"]  =self.calc_16bit(resp,3)/100
        return to_send
    def rdwdmasa(self,resp,to_send):
        to_send["air_winddir"]  =self.calc_16bit(resp,3)/10
        return to_send
    def rdlth01(self,resp,to_send):
        to_send["air_leaftemp"]  =self.calc_16bit(resp,3)/10
        to_send["air_leafhum"]  =self.calc_16bit(resp,5)/10
        return to_send