import time
import machine
import gc
import pycom
import sys
from network import WLAN
import bme280 as bme280
from ina219 import INA219
from gpio import GPIO
from TCA9534 import TCA9534
import module1 as shared
import hondetec
from binascii import hexlify
scope_id="0ne00357BCB"
#variables used
valves=0    #2 bits for every valve
pumps=0     #2 bits for every pump
to_send={}
properties={}
errors=""
rs485_log=""
readingSensors=0
device_id=hexlify(machine.unique_id()).decode('utf-8').upper()
print("\r\nDevice ID:")
print(device_id)
update_time=0
wdt = machine.WDT(timeout=5*60*1000)
if device_id=='F008D1CB9C44':
    device_id='F008D1CB9C90'
if device_id=='F008D1CB9C90':
    key='KmCcaNBACVVCZBRvQxs5p4HptGtCj5gutoabMmwyfB8='
    update_time=60*1000
if device_id=='F008D1CB9C3C':
    key='utoovixnImMZEDn5vF8UnZVjj17SDAMb0T22kN3IFX0='
    update_time=10*60*1000
if device_id=='F008D1CB9C44':
    key='Z/hmvuXUoq1djHD8MYhgY0ZY08LXvF0MnqZoJQ+Ea2o='
    update_time=10*60*1000
if device_id=='F008D1CBAD10':
    key=''
    update_time=1000    
def calc_16bit(value,pos):
    return (value[pos]<<8)|value[pos+1]
#_test_relays    = 1
#_test_rs485     = 1
pycom.heartbeat(False)
gc.disable()
print('')
print('Rebooting...')
pin_i2c_en = machine.Pin(shared.PIN_3V3_SW_EN, mode=machine.Pin.OUT)
pin_i2c_en.value(1)
i2c1 = machine.I2C(1,pins=(shared.PIN_I2C1_SDA,shared.PIN_I2C1_SCL))
i2c2 = machine.I2C(0,pins=(shared.PIN_I2C2_SDA,shared.PIN_I2C2_SCL))
uart = machine.UART(1, baudrate=9600, timeout_chars=10, pins=(shared.PIN_TX1,shared.PIN_RX1))#TXD, RXD, RTS and CTS 
timer=machine.Timer.Chrono()
bme = bme280.BME280(i2c=i2c2, address=shared.ADDR_BME280)
ina = INA219(shunt_ohms=shared.INA219_SHUNT_OHMS, i2c=i2c2, max_expected_amps=None, address=shared.ADDR_INA219)
pca = GPIO(i2c=i2c2, address=shared.ADDR_PCA9539)
tca = TCA9534(i2c=i2c1, address=shared.ADDR_TCA9534)
ina.configure()
pca.writeOut(shared.PCA9539_OUT_MASK)
pca.writePolarity(shared.PCA9539_POL_MASK)
pca.writeDirection(shared.PCA9539_DIR_MASK)
pca.setOutHigh(1<<shared.PCA9539_POW_I2C_EXT)
time.sleep_ms(100)
wlan = WLAN(mode=WLAN.STA, antenna=WLAN.EXT_ANT)
wifi_pass=''
nets = wlan.scan()
for net in nets:
    if net.ssid == 'SINTARA':
        wifi_pass='sintara1'
        break
#    if net.ssid == 'XTRATECRO':
#        wifi_pass='xtec2012'
#        break
    if net.ssid == 'SINTARA1':
        wifi_pass='sintara1'
        break
    if net.ssid == 'bzk':
        wifi_pass='cacacacaca'
        break
i=0
if wifi_pass != '':
    wlan.connect(net.ssid, auth=(net.sec, wifi_pass), timeout=10000)
    while not wlan.isconnected():
        time.sleep_ms(50)
        i=i+1
        if i == 100:
            machine.reset()
if not wlan.isconnected():
    for net in nets:
        print(net)
    print("Could not connect, rebooting in 5s")
    time.sleep(5)
    machine.reset()
if wlan.ifconfig()[0]=='0.0.0.0':
    print("Did not get a valid IP, rebooting in 5s")
    time.sleep(5)
    machine.reset()
print('Connected to SSID[{}]. Got IP address: [{}]'.format(net.ssid,wlan.ifconfig()[0]))
rtc = machine.RTC()
rtc.ntp_sync("pool.ntp.org")
while not rtc.synced():
    machine.idle()
t=rtc.now()
print('RTC Set from NTP to UTC: {:04d}-{:02d}-{:02d} {:02d}:{:02d}:{:02d}'.format(t[0], t[1], t[2], t[3], t[4], t[5]))
time.timezone(3*60**2) #we are located at GMT+2, thus 2*60*60
t=time.localtime()
print('Adjusted from UTC to RO timezone: {:04d}-{:02d}-{:02d} {:02d}:{:02d}:{:02d}'.format(t[0], t[1], t[2], t[3], t[4], t[5]))
month=t[1]
from iotc import IoTCClient,IoTCConnectType,IoTCLogLevel,IoTCEvents
client=IoTCClient(scope_id,device_id,IoTCConnectType.DEVICE_KEY,key)
client.set_log_level(IoTCLogLevel.ALL)#DISABLED)
def on_properties(name, value):
    print('Received property {} with value {}'.format(name, value))
    return value




client.on(IoTCEvents.PROPERTIES, on_properties)
client.on(IoTCEvents.COMMANDS, on_commands)
try: _test_relays
except NameError:
    pass
else:
    i=1
    while 1:
        tca.writeOut(i)
        i<<=1
        time.sleep(5)
        if i==0x40 :
            i=1

pca.setOutHigh(1<<(shared.PCA9539_POW_RS485))
while 1:
    if client.is_connected():
        client.listen()
        if timer.read_ms()>update_time :           
            pycom.rgbled(0x007f00)
            timer.stop()
            timer.reset()
            timer.start()
            #empty values
            to_send={}
            properties={}
            errors=''
            #write valve states

            properties["valve_s1"]=get_2bit(valves,0)
            if(properties["valve_s1"]==0):
                properties["valve_s1"]=9
            properties["valve_s2"]=get_2bit(valves,1)
            if(properties["valve_s2"]==0):
                properties["valve_s2"]=9
            properties["valve_s3"]=get_2bit(valves,2)
            if(properties["valve_s3"]==0):
                properties["valve_s3"]=9
            properties["valve_s4"]=get_2bit(valves,3)
            if(properties["valve_s4"]==0):
                properties["valve_s4"]=9
            properties["valve_s5"]=get_2bit(valves,4)
            if(properties["valve_s5"]==0):
                properties["valve_s5"]=9
            properties["valve_s6"]=get_2bit(valves,5)
            if(properties["valve_s6"]==0):
                properties["valve_s6"]=9
            properties["valve_s7"]=get_2bit(valves,6)
            if(properties["valve_s7"]==0):
                properties["valve_s7"]=9
            properties["valve_s8"]=get_2bit(valves,7)
            if(properties["valve_s8"]==0):
                properties["valve_s8"]=9
            #get internal stuff, mark as air stuff for now
            to_send["air_temperature"], to_send["air_pressure"], to_send["air_humidity"] = bme.read_compensated_data()
            ina.wake()
            to_send["internal_voltage"]=ina.voltage()
            to_send["internal_current"]=ina.current()
            ina.sleep()
            #get RS485 info
            readingSensors=1
            soil()
            sun()
            water()
            air()
            properties["ERRORS"]=errors
            readingSensors=0
            conv=timer.read_ms()
            properties["internal_month"]=month
            if client.is_connected():
                wdt.feed()
                client.send_telemetry(to_send)
                properties["freemem"]=(gc.mem_free()/1024)
                client.send_property(properties)
                properties={}
                to_send={}
            else:
                print('Disconnected!!')
                client.connect()
            sent_time=timer.read_ms()
            gc.collect()
            t=time.localtime()
            print('[{:04d}-{:02d}-{:02d} {:02d}:{:02d}:{:02d}]: tREAD={:.3f}ms, tSEND={:.3f}ms. Memory available: {:.3f} kB'.format(t[0], t[1], t[2], t[3], t[4], t[5], conv, (sent_time-conv), (gc.mem_free()/1024)))
            pycom.rgbled(0x000000)
    else:
        print('Not connected!')
        pycom.rgbled(0x7f0000)
        client.connect()
        timer.start()
        pycom.rgbled(0x000000)



def set_bit(value, bit):
    return value | (1<<bit)
def set_2bit(value,bit):
    return value | (1<<(bit*2))
def clear_bit(value, bit):
    return value & ~(1<<bit)
def clear_2bit(value, bit):
    return value & ~(3<<(bit*2))
def get_bit(value,bit):
    return (value >> bit)&1
def get_2bit(value, bit):
    return (value>>(bit*2))&3
def soil():
    #enable all
    global errors, to_send, properties
    sen=hondetec.sensors_485()
    pca.setOutHigh(1<<(shared.PCA9539_J12_1))
    time.sleep_ms(50)
    pca.setOutLow(1<<(shared.PCA9539_J12_1))
    time.sleep_ms(50)
    resp=send_485(hondetec.RD_ALLSOIL_INIT)
    print(resp)
    time.sleep_ms(2000)
    
    resp=send_485(hondetec.RD_STS_3LMT)
    if len(resp)>1:
        to_send=sen.rdsts3lmt(resp,to_send)
    else:
        print('ID 02 Error')
    # RD_SCO2R_01
    resp=send_485(hondetec.RD_SCO2R_01)
    if len(resp)>1:
        to_send=sen.rdsco2r01(resp,to_send)
    else:
        print('ID 03 Error')
        errors+="|03"
    # RD_SPHAG_RD
    resp=send_485(hondetec.RD_SPHAG_RD)
    if len(resp)>1:
        to_send=sen.rdsphagrd(resp,to_send)
    else:
        print('ID 04 Error')
        errors+="|04"
    # RD_SCH2H4R_01
    resp=send_485(hondetec.RD_SCH2H4R_01)
    if len(resp)>1:
        to_send=sen.rdsch2h4r(resp,to_send)
    else:
        print('ID 06 Error')
        errors+="|06"
    # RD_S7
    resp=send_485(hondetec.RD_S7)
    if len(resp)>1:
        to_send=sen.rds7(resp,to_send)
    else:
        print('ID 07 Error')
        errors+="|07"
    # RD_S8IN1
    resp=send_485(hondetec.RD_S8IN1)
    if len(resp)>1:
        to_send=sen.rds8in1(resp,to_send)
    else:
        print('ID 08 Error')
        errors+="|08"
    # RD_S4
    resp=send_485(hondetec.RD_S4)
    if len(resp)>1:
        to_send=sen.rds4(resp,to_send)
    else:
        print('ID 09 Error')
        errors+="|09"
    # RD_ALLSOIL
    time.sleep_ms(2000)
    resp=send_485(hondetec.RD_ALLSOIL_RD)
    if len(resp)>1:
        to_send=sen.rdallsoil(resp,to_send)
    else:
        print('ID 0A Error')
        errors+="|0A"
    resp=send_485(hondetec.RD_ALLSOIL_SLP)
def sun():
    global errors, to_send, properties
    sen=hondetec.sensors_485()
    #enable all
    pca.setOutHigh(1<<(shared.PCA9539_J12_2))
    time.sleep_ms(10)
    pca.setOutLow(1<<(shared.PCA9539_J12_2))
    time.sleep_ms(50)
    #RD-PAS-01
    resp=send_485(hondetec.RD_PAS_01)
    if len(resp)>1:
        to_send=sen.rdpas01(resp,to_send)
    else:
        print('ID 13 Error')
        errors+="|13"
    #RD-TSR-02
    resp=send_485(hondetec.RD_TSR_02)
    if len(resp)>1:
        to_send=sen.rdtsr02(resp,to_send)
    else:
        print('ID 14 Error')
        errors+="|14"
    #RD-UVS-01
    resp=send_485(hondetec.RD_UVS_01)
    if len(resp)>1:
        to_send=sen.rduvs01(resp,to_send)
    else:
        print('ID 15 Error')
        errors+="|15"
    #RD-W-O-01
    resp=send_485(hondetec.RD_W_O_01)
    if len(resp)>1:
        to_send=sen.rdwo01(resp,to_send)
    else:
        print('ID 16 Error')
    #RD-PSR-01
    resp=send_485(hondetec.RD_PSR_01)
    if len(resp)>1:
        to_send=sen.rdpsr01(resp,to_send)
    else:
        print('ID 17 Error')
def water():
    global errors, to_send, properties
    sen=hondetec.sensors_485()
    # RD-WPS-01-1
    resp=send_485(hondetec.RD_WPSP01_1)
    if len(resp)>1:
        to_send=sen.rdwpsp011(resp,to_send)
    else:
        print('ID 21 Error')
        errors+="|21"
    # RD-WPS-01-2
    resp=send_485(hondetec.RD_WPSP01_2)
    if len(resp)>1:
        to_send=sen.rdwpsp012(resp,to_send)
    else:
        print('ID 22 Error')
        errors+="|22"
    # RD-WPH_IT
    resp=send_485(hondetec.RD_WPH_IT)
    if len(resp)>1:
        to_send=sen.rdwphit(resp,to_send)
    else:
        print('ID 23 Error')
        errors+="|23"
    # RD_UWLDH3_01
    resp=send_485(hondetec.RD_UWLDH3_01)
    if len(resp)>1:
        to_send=sen.rduwldh301(resp,to_send)
    else:
        print('ID 24 Error')
        errors+="|24"
def air():
    global errors, to_send, properties
    sen=hondetec.sensors_485()
    # AOTCNN4IN1
    resp=send_485(hondetec.RD_AOTCNN4IN1)
    if len(resp)>1:
        to_send=sen.aotcnn4in1(resp,to_send)
    else:
        print('ID 31 Error')
        errors+="|31"
    # AOCNOS4IN1
    resp=send_485(hondetec.RD_AOCNOS4IN1)
    if len(resp)>1:
        to_send=sen.aocnos4in1(resp,to_send)
    else:
        print('ID 32 Error')
        errors+="|32"
    # RD_WSM_ASA
    resp=send_485(hondetec.RD_WSM_ASA)
    if len(resp)>1:
        to_send=sen.rdwsmasa(resp,to_send)
    else:
        print('ID 33 Error')
        errors+="|33"
    # RD_WDM_ASA
    resp=send_485(hondetec.RD_WDM_ASA)
    if len(resp)>1:
        to_send=sen.rdwdmasa(resp,to_send)
    else:
        print('ID 34 Error')
        errors+="|34"
    # RD_LTH_01
    resp=send_485(hondetec.RD_LTH_01)
    if len(resp)>1:
        to_send=sen.rdlth01(resp,to_send)
    else:
        print('ID 35 Error')
        errors+="|35"

def on_commands(command, ack):
    ack(command, command.payload)
    temp=command.name
    global valves, readingSensors
    if(temp[0:6]=='valve_'):
        while(readingSensors):
            pass
        v=temp[6]
        if(temp[7]=='1'):
            resp=send_485('v'+v+'1')
            print("Valve"+v+" ON")
            valves=set_2bit(valves,int(v)-1)
        if(temp[7]=='0'):
            resp=send_485('v'+v+'0')
            print("Valve"+v+" OFF")
            valves=clear_2bit(valves,int(v)-1)
    if(temp[0:5]=='pump_'):
        while(readingSensors):
            pass
        p=temp[5]
        if(temp[6]=='1'):
            resp=send_485('p'+p+'1')
            print("Pump"+p+" ON")
            pumps=set_2bit(pumps,int(p)-1)
        if(temp[6]=='0'):
            resp=send_485('p'+p+'0')
            print("Pump"+p+" OFF")
            pumps=clear_2bit(pumps,int(p)-1)
    if(temp[0:5]=='RESET'):
        time.sleep(5)
        machine.reset()

def on_enqueued(command):
    print('Enqueued Command {}.'.format(command.name))


def send_485(str):
    global rs485_log
    pca.setOutHigh(1<<(shared.PCA9539_DIR_RS485))
    rs485_log+='\r\nSent:'+str
    uart.write(str)
    while not (uart.wait_tx_done(1)):
        machine.idle()
    pca.setOutLow(1<<(shared.PCA9539_DIR_RS485))
    time.sleep_ms(200)
    resp=''
    if uart.any():
        resp=uart.read()
    rs485_log+='\r\nReceived:'+resp
    return resp