#include "board_defs.h"
extern uint8_t state;
/*
Pini folositi:
PD0: CHG_ENABLE(OUT)
PD1: 9V_ENABLE(OUT)
PD2: BUT1(IN)
PD3: BUT2(IN)
PD4: 2_1	on pe 1
PD5: 1_1	on pe 1
PD6: 1_2	on pe 0
PD7: 2_2	on pe 1

*/
void system_clocks_init(void){
	unsigned char n,s;
	s=SREG;
	// Disable interrupts

	// Internal 32 MHz RC oscillator initialization
	// Enable the internal 32 MHz RC oscillator
	OSC.CTRL|=OSC_RC32MEN_bm;

	// System Clock prescaler A division factor: 1
	// System Clock prescalers B & C division factors: B:1, C:1
	// ClkPer4: 32000.000 kHz
	// ClkPer2: 32000.000 kHz
	// ClkPer:  32000.000 kHz
	// ClkCPU:  32000.000 kHz
	n=(CLK.PSCTRL & (~(CLK_PSADIV_gm | CLK_PSBCDIV1_bm | CLK_PSBCDIV0_bm))) |
	CLK_PSADIV_1_gc | CLK_PSBCDIV_1_1_gc;
	CCP=CCP_IOREG_gc;
	CLK.PSCTRL=n;

	// Disable the auto-calibration of the internal 32 MHz RC oscillator
	DFLLRC32M.CTRL&= ~DFLL_ENABLE_bm;

	// Wait for the internal 32 MHz RC oscillator to stabilize
	while ((OSC.STATUS & OSC_RC32MRDY_bm)==0);

	// Select the system clock source: 32 MHz Internal RC Osc.
	n=(CLK.CTRL & (~CLK_SCLKSEL_gm)) | CLK_SCLKSEL_RC32M_gc;
	CCP=CCP_IOREG_gc;
	CLK.CTRL=n;

	// Disable the unused oscillators: 2 MHz, internal 32 kHz, external clock/crystal oscillator, PLL
	OSC.CTRL&= ~(OSC_RC2MEN_bm | OSC_RC32KEN_bm | OSC_XOSCEN_bm | OSC_PLLEN_bm);

	// ClkPer output disabled
	PORTCFG.CLKEVOUT&= ~(PORTCFG_CLKOUTSEL_gm | PORTCFG_CLKOUT_gm);
	// Restore interrupts enabled/disabled state
	SREG=s;
}
void init_board(void){
	uint8_t n;
	PORTC.OUT=0b00101000;
	PORTC.DIR=0b11111011;
	//PD2,PD3-BUTOANE
	PORTD.PIN2CTRL=PORT_OPC_PULLUP_gc|PORT_ISC_BOTHEDGES_gc;
	PORTD.PIN3CTRL=PORT_OPC_PULLUP_gc|PORT_ISC_BOTHEDGES_gc;
	PORTD.INTCTRL=PORT_INT0LVL_MED_gc;
	PORTD.INT0MASK=0x0C;
	PORTD.OUT=0b01000000;//toate fet-urile sunt oprite
	PORTD.DIR=0b11110011;
	
	PORTE.OUT=0b00000000;
	PORTE.DIR=0b11110000;
	n=(PMIC.CTRL & (~(PMIC_RREN_bm | PMIC_IVSEL_bm | PMIC_HILVLEN_bm | PMIC_MEDLVLEN_bm | PMIC_LOLVLEN_bm))) |
	PMIC_LOLVLEN_bm | PMIC_MEDLVLEN_bm | PMIC_HILVLEN_bm;
	CCP=CCP_IOREG_gc;
	PMIC.CTRL=n;
	// Set the default priority for round-robin scheduling
	PMIC.INTPRI=0x00;
}

void led(uint8_t val){
	switch(val){
		case 0:
			PORTE.OUTCLR=0x20;
			break;
		case 1:
			PORTE.OUTSET=0x20;
			break;
		default:
			break;
	}
}
void ch1(uint8_t val){
	uint8_t i=PORTD.OUT&(~0x60);
	//first disable all
	PORTD.OUT=i|0x40;
	_delay_us(10);
	switch(val){
		case 0://1.1 si 1.2 sunt pe 1
			PORTD.OUT=i|0x60;
			break;
		case 1:
			PORTD.OUT=i|0x00;
			break;
		default:
			break;
		
	}
}
void ch2(uint8_t val){
	uint8_t i=PORTD.OUT&(~0x90);
	//first disable all
	PORTD.OUT=i;
	_delay_us(10);
	switch(val){
		case 0://1.1 si 1.2 sunt pe 1
			PORTD.OUT=i|0x10;
			break;
		case 1:
			PORTD.OUT=i|0x80;
			break;
		default:
			break;
		
	}
}
void charge(uint8_t val){
	switch(val){
		case 0:
			PORTD.OUTCLR=0x01;
			break;
		case 1:
			PORTD.OUTSET=0x01;
			break;
		default:
			break;
	}
}
void open(void){
	tcd0_init();
	_delay_ms(10);
	ch1(0);
	ch2(1);
	_delay_ms(250);
	ch1(2);
	ch2(2);
	tcd0_deinit();
}
void close(void){
	ch1(1);
	ch2(0);
	_delay_ms(100);//62
	ch1(2);
}
void usart_init(void){
	PORTC.OUTSET=0x08;

	// Communication mode: Asynchronous USART
	// Data bits: 8
	// Stop bits: 1
	// Parity: Disabled
	USARTC0.CTRLC=USART_CMODE_ASYNCHRONOUS_gc | USART_PMODE_DISABLED_gc | USART_CHSIZE_8BIT_gc;

	// Receive complete interrupt: Disabled
	// Transmit complete interrupt: Disabled
	// Data register empty interrupt: Disabled
	USARTC0.CTRLA=USART_RXCINTLVL_MED_gc;

	// Required Baud rate: 9600
	// Real Baud Rate: 9601.0 (x1 Mode), Error: 0.0 %
	USARTC0.BAUDCTRLA=0x85;
	USARTC0.BAUDCTRLB=((0x09 << USART_BSCALE_gp) & USART_BSCALE_gm) | 0x0C;

	// Receiver: On
	// Transmitter: On
	// Double transmission speed mode: Off
	// Multi-processor communication mode: Off
	USARTC0.CTRLB=(USARTC0.CTRLB & (~(USART_RXEN_bm | USART_TXEN_bm | USART_CLK2X_bm | USART_MPCM_bm | USART_TXB8_bm))) |
	USART_RXEN_bm | USART_TXEN_bm | USART_CLK2X_bm;
}
void putch(char c)
{
	while ((USARTC0.STATUS & USART_DREIF_bm) == 0);
	USARTC0.DATA=c;
}
void sendAck(void){
	setDir(1);
	_delay_ms(10);
	putch(0xf0);
	_delay_ms(10);
	putch(state);
	while ((USARTC0.STATUS & USART_DREIF_bm) == 0);
	_delay_ms(10);
	setDir(0);
}
void setDir(uint8_t dir){
	switch(dir){
		case 0:	//receive mode
			PORTC.OUT=PORTC.OUT&0xCF;
			break;
		case 1: //send mode
			PORTC.OUT=(PORTC.OUT&0xCF)|0x30;
			break;
		default: //transmitter and receiver disabled
			PORTC.OUT=(PORTC.OUT&0xCF)|0x20;
			break;
	}	
}
void tcd0_deinit(void){
	TCD0.CTRLA=TC_CLKSEL_OFF_gc;
	TCD0.CTRLFSET=TC_CMD_RESET_gc;
	PORTD.OUTSET=0x02;
}
void tcd0_init(void){
		tcd0_deinit();
		TCD0.CTRLA=TC_CLKSEL_DIV1_gc;
		TCD0.CTRLB=TC0_CCBEN_bm | TC_WGMODE_DS_TB_gc;
		TCD0.CTRLD=0;
		TCD0.CTRLE=TC_BYTEM_NORMAL_gc;
		TCD0.INTCTRLA=0;
		TCD0.INTCTRLB=0;
		TCD0.INTFLAGS=TCD0.INTFLAGS;
		TCD0.CNT=0x0000;
		TCD0.PER=100;//10kHz@clk=2MHz
		TCD0.CCA=0;
		TCD0.CCB=50;
		TCD0.CCC=0;
		TCD0.CCD=0;
}