#include "board_defs.h"
volatile uint8_t state, oldState;
volatile uint8_t slp;
volatile uint8_t buffer[8];
volatile uint8_t buffer_pos;

int main (void)
{
	oldState=2;
	state=0;
	slp=0;
	buffer_pos=0;
	//system_clocks_init();
	init_board();
	usart_init();
	sei();
	charge(1);
	while(1){
		if(state!=oldState){
			switch(state){
				case 0:
					close();
					oldState=state;
					led(1);
					_delay_ms(200);
					led(0);
					break;
				case 1:
					open();
					oldState=state;
					led(1);
					_delay_ms(1000);
					led(0);
					break;
				default:
					state=oldState;
					break;
			}
			sendAck();
		}
		if(slp==200){//2 secunde timeout rx
			buffer_pos=0;
			slp=0;
			//led(0);
		}
		if(slp>0){
			_delay_ms(100);
			slp++;
		}
	}
}
ISR(PORTD_INT0_vect){
	if((PORTD.IN&0x04)==0)
		state=1;
	if((PORTD.IN&0x08)==0)
		state=0;
}
ISR(USARTC0_RXC_vect){
	unsigned char status;
	char data;
	status=USARTC0.STATUS;
	data=USARTC0.DATA;
	if ((status & (USART_FERR_bm | USART_PERR_bm | USART_BUFOVF_bm)) == 0){
		switch(buffer_pos){
			case 0:
				if(data=='v'){
					buffer_pos=1;
					slp=1;
				}
				break;
			case 1:
				if(data=='6'){
					buffer_pos=2;
				}
				else if(data==0xf0){
					buffer_pos=1;
				}
				else{
					buffer_pos=0;
				}
				break;
			case 2:
				if(data=='1')
					state=1;
				if(data=='0')
					state=0;
				if(data=='9')
					state=3;
				buffer_pos=0;
				slp=0;
				break;
			default:
				break;
		}
	}
}