// ==========================================================================
// flash.c
// (c) 2020, Aurel Dumitru
//
// Description:
// RGB LED control
// =========================================================================

#include "flap.h"
#include "main.h"
#include "utils.h"


void Flap_SetIrState(uint8_t State)
{
	if (State)
		HAL_GPIO_WritePin(EN_LED_IR_GPIO_Port, EN_LED_IR_Pin, GPIO_PIN_SET);
	else
		HAL_GPIO_WritePin(EN_LED_IR_GPIO_Port, EN_LED_IR_Pin, GPIO_PIN_RESET);
}


uint32_t Flap_GetIrCurrent(void)
{
	ADC_ChannelConfTypeDef AdcChConfig;

	AdcChConfig.Channel = ADC_CHANNEL_0;
	AdcChConfig.Rank = ADC_REGULAR_RANK_1;
	AdcChConfig.SamplingTime = ADC_SAMPLETIME_64CYCLES_5;
	AdcChConfig.SingleDiff = ADC_SINGLE_ENDED;
	AdcChConfig.OffsetNumber = ADC_OFFSET_NONE;
	AdcChConfig.Offset = 0;
	AdcChConfig.OffsetRightShift = DISABLE;
	AdcChConfig.OffsetSignedSaturation = DISABLE;
	HAL_ADC_ConfigChannel(&hadc2, &AdcChConfig);
	HAL_ADC_Start(&hadc2);
	Utils_DelayMicroseconds(50);
	return HAL_ADC_GetValue(&hadc2) & 0xFFFF;
}


uint8_t Flap_GetTiltSensorValue(void)
{
	return HAL_GPIO_ReadPin(TILT_GPIO_Port, TILT_Pin);
}
