// ==========================================================================
// flash.c
// (c) 2020, Aurel Dumitru
//
// Description:
// RGB LED control
// =========================================================================

#include "rgbled.h"
#include "main.h"

uint16_t Rgbled_Frame[6];
uint32_t Rgbled_Status;

void Rgbled_SetColor(uint16_t BrightnesPercentage, uint32_t RGB)
{
	if (RGB <= 0xFFFFFF)
	{
		Rgbled_Frame[2] = 0xE000 | (((BrightnesPercentage*31)/100)<<8) | (uint16_t)(RGB>>16);
		Rgbled_Frame[3] = (uint16_t)(((RGB<<8)&0xFF00) | ((RGB>>8)&0x00FF));
		HAL_SPI_Transmit(&hspi6, (uint8_t*)Rgbled_Frame, 6, 10);
		Rgbled_Status = RGB;
	}
}

void Rgbled_Init(void)
{
	uint16_t* Ptr = Rgbled_Frame;
	*Ptr++ = 0x0000;
	*Ptr++ = 0x0000;
	*Ptr++ = 0xE000;
	*Ptr++ = 0x0000;
	*Ptr++ = 0xFFFF;
	*Ptr++ = 0xFFFF;
	HAL_SPI_Transmit(&hspi6, (uint8_t*)Rgbled_Frame, 6, 10);
	Rgbled_Status = 0;
}

uint32_t Rgbled_GetStatus(void)
{
	return Rgbled_Status;
}
