#include <opencv2/opencv.hpp>
#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <windows.h>

using namespace cv;

const uint8_t SensorsAdress[60] = {
/* 0*/  0, /* 1*/ 33, /* 2*/ 16, /* 3*/ 13, /* 4*/ 10, /* 5*/ 38, /* 6*/  0, /* 7*/  0, /* 8*/  0, /* 9*/  0,
/*10*/  0, /*11*/  0, /*12*/  0, /*13*/  0, /*14*/  0, /*15*/  0, /*16*/  0, /*17*/  0, /*18*/  0, /*19*/  0,
/*20*/  8, /*21*/  9, /*22*/  4, /*23*/  1, /*24*/129, /*25*/130, /*26*/131, /*27*/132, /*28*/133, /*29*/134,
/*30*/  0, /*31*/  0, /*32*/  0, /*33*/  0, /*34*/  0, /*35*/  0, /*36*/  0, /*37*/  0, /*38*/  0, /*39*/  0,
/*40*/  3, /*41*/ 37, /*42*/  6, /*43*/  0, /*44*/  0, /*45*/  0, /*46*/  0, /*47*/  0, /*48*/  0, /*49*/  0,
/*50*/  0, /*51*/  0, /*52*/  0, /*53*/  0, /*54*/  0, /*55*/  0, /*56*/  0, /*57*/  0, /*58*/  0, /*59*/  0,
};

uint8_t CameraBuff[1024*1024*2];
uint8_t CameraBuffRgb[960*960*3];
uint8_t DevStat[10];
uint8_t SendCmd[8] = {0xA5, 0x01, 0x01, 3, 192, 0x01, 0x00, 0x00};
char ComNumber[10];
uint32_t CameraHorizontalPixels = 960;
uint32_t CameraVerticalPixels = 960;

#define L CameraHorizontalPixels
#define LC (L+4)

void Camera_Demosaicing(void)
{
	uint8_t*  Dest = CameraBuffRgb;
	uint16_t* Src  = (uint16_t*)CameraBuff + 2*LC + 2;
	uint32_t I, J;

	for (I=0; I<CameraVerticalPixels; I++)
	{
		for (J=0; J<CameraHorizontalPixels; J++)
		{
			if ((I&1))
			{
				if ((J&1))
				{
					*Dest++ = (uint8_t)((*(Src-1) + *(Src+1)) >> 5); //BLUE
					*Dest++ = (uint8_t)((*Src)>>4); 		         //GREEN
					*Dest++ = (uint8_t)((*(Src-LC) + *(Src+LC)) >> 5); //RED
				}
				else
				{
					*Dest++ = (uint8_t)((*Src)>>4); 											   //BLUE
					*Dest++ = (uint8_t)((*(Src-LC) + *(Src+LC) + *(Src-1) + *(Src+1)) >> 6);		   //GREEN
					*Dest++ = (uint8_t)((*(Src-LC-1) + *(Src-LC+1) + *(Src+LC-1) + *(Src+LC+1)) >> 6); //RED
				}
			}
			else
			{
				if ((J&1))
				{
					*Dest++ = (uint8_t)((*(Src-LC-1) + *(Src-LC+1) + *(Src+LC-1) + *(Src+LC+1)) >> 6); //BLUE
					*Dest++ = (uint8_t)((*(Src-LC) + *(Src+LC) + *(Src-1) + *(Src+1)) >> 6); 		   //GREEN
					*Dest++ = (uint8_t)((*Src)>>4); 		   									   //RED
				}
				else
				{
					*Dest++ = (uint8_t)((*(Src-LC) + *(Src+LC)) >> 5); //BLUE
					*Dest++ = (uint8_t)((*Src)>>4);					 //GREEN
					*Dest++ = (uint8_t)((*(Src-1) + *(Src+1)) >> 5); //RED
				}
			}
			Src++;
		}
		Src += 4;
	}
}


uint32_t Compute_Fvol4(void)
{
    uint32_t I, J;
    uint32_t Fvol4;
    double Sum1Fvol4 = 0.0f;
    double Sum2Fvol4 = 0.0f;
    double Y0, Y1, Y2;
    uint8_t* Src = CameraBuffRgb;

    for (I=0; I<CameraVerticalPixels; I++)
    {
        Y0 = 0.11f*(*Src++); Y0 += 0.59f*(*Src++); Y0 += 0.3f*(*Src++);
        Y1 = 0.11f*(*Src++); Y1 += 0.59f*(*Src++); Y1 += 0.3f*(*Src++);
        for (J=0; J<(CameraHorizontalPixels-2); J++)
        {
            Y2 = 0.11f*(*Src++); Y2 += 0.59f*(*Src++); Y2 += 0.3f*(*Src++);
            Sum1Fvol4 += Y0*Y1;
            Sum2Fvol4 += Y0*Y2;
            Y0 = Y1;
            Y1 = Y2;
        }
        Sum1Fvol4 += Y0*Y1;
    }
    Fvol4 = (uint32_t)((Sum1Fvol4 - Sum2Fvol4)/1000);
    return Fvol4;
}


int main()
{

    DCB dcb;
    HANDLE hCom;
    //long unsigned int BytesRead;
    long unsigned int BytesWrite;
    uint8_t KeyPress;
    uint32_t I,J = 0;
    SYSTEMTIME time;
    uint32_t TimePrev, TimeCur;
    char TmpChar[256];
    char RgbLedColor[10];
    char ComNumberPath[20] = "\\\\.\\COM";
    int TmpInt;
    uint32_t Fvol4;
    int8_t Tmp8Int;

    printf("Please input COM number (just number): ");
    scanf("%s", ComNumber);

    strcat(ComNumberPath, ComNumber);
    hCom = CreateFile(ComNumberPath,
                        GENERIC_READ | GENERIC_WRITE,
                        0,      //  must be opened with exclusive-access
                        NULL,   //  default security attributes
                        OPEN_EXISTING, //  must use OPEN_EXISTING
                        0,      //  not overlapped I/O
                        NULL); //  hTemplate must be NULL for comm devices

    if (hCom == INVALID_HANDLE_VALUE)
        //  Handle the error.
        printf("CreateFile failed with error %lu.\n", GetLastError());
    else
    {
        if (SetupComm(hCom,65536,65536) !=0)
            printf("Windows In/Out serial buffers changed to 64kb\n");
        else
            printf("Buffers not changed with error %lu.\n", GetLastError());
    }

    COMMTIMEOUTS Timeouts;
    Timeouts.ReadIntervalTimeout = 0;
    Timeouts.ReadTotalTimeoutMultiplier = 0;
    Timeouts.ReadTotalTimeoutConstant = 1000;
    Timeouts.WriteTotalTimeoutMultiplier = 0;
    Timeouts.WriteTotalTimeoutConstant = 0;
    SetCommTimeouts(hCom, &Timeouts);


    //  Initialize the DCB structure.
    SecureZeroMemory(&dcb, sizeof(DCB));
    dcb.DCBlength = sizeof(DCB);
    GetCommState(hCom, &dcb);
    printf("\nBaudRate = %lu, ByteSize = %d, Parity = %d, StopBits = %d\n", dcb.BaudRate, dcb.ByteSize, dcb.Parity, dcb.StopBits);
    PurgeComm(hCom, PURGE_RXCLEAR|PURGE_TXCLEAR|PURGE_RXABORT|PURGE_TXABORT);


    printf("\nSensors address configuration (y/n)?: ");
    scanf("%s", TmpChar);
    if (TmpChar[0] != 'y')
    {
        printf("Crop resolution (e.g. 240, 320, 480, 960): ");
        scanf("%d", &TmpInt);
        CameraHorizontalPixels = (uint32_t)TmpInt;
        CameraVerticalPixels   = (uint32_t)TmpInt;
        SendCmd[3] = (uint8_t)(CameraHorizontalPixels/256);
        SendCmd[4] = (uint8_t)(CameraHorizontalPixels%256);

        printf("Deactivate camera FLASH (y/n)?: ");
        scanf("%s", TmpChar);
        if (TmpChar[0] == 'y')        SendCmd[1] = 0x00;
        printf("Deactivate RGB LED? (y/n): ");
        scanf("%s", TmpChar);
        if (TmpChar[0] == 'y')        SendCmd[2] = 0x00;
        printf("Deactivate motors? (y/n): ");
        scanf("%s", TmpChar);
        if (TmpChar[0] == 'y')        SendCmd[5] = 0x00;

        Mat Camera = Mat(CameraHorizontalPixels, CameraVerticalPixels, CV_8UC3, &CameraBuffRgb);
        std::string CameraWindow = "Camera";
        namedWindow(CameraWindow, WINDOW_AUTOSIZE);

        while(1)
        {
        PurgeComm(hCom, PURGE_RXCLEAR);
        uint32_t Size = ((CameraHorizontalPixels+4)*(CameraVerticalPixels+4)*2 + 1024) & 0xFFFFF400;
        uint32_t SizeRx = 60*1024;
        for (I=0; I<50; I++)
        {
            WriteFile(hCom, SendCmd, sizeof(SendCmd), &BytesWrite, 0);
            if (I == 0)
                ReadFile(hCom, DevStat, 16, NULL, 0);
            if (Size > SizeRx)
            {
                if (ReadFile(hCom, CameraBuff + (I*60*1024), 60*1024, NULL, 0) == 0)
                    break;
            }
            else
            {
                ReadFile(hCom, CameraBuff + (I*60*1024), Size, NULL, 0);
                break;
            }
            Size -= SizeRx;
        }
        Camera_Demosaicing();
        Fvol4 = Compute_Fvol4();

        GetSystemTime(&time);
        TimeCur = (time.wSecond * 1000) + time.wMilliseconds;
        if (TimeCur < TimePrev)
            TimeCur += 1000;
        uint32_t FrameRate = 10000 / (TimeCur-TimePrev);
        uint32_t TransferRate = (FrameRate*2400/1024);
        TimePrev = TimeCur;

        putText(Camera,
                "FPS: "+std::to_string(FrameRate/10)+"."+std::to_string(FrameRate%10)+"/s  Focus: "+std::to_string(Fvol4),
                Point(5, 20/*310*/),
                FONT_HERSHEY_SIMPLEX,
                0.4,
                Scalar(255, 255, 255),
                1);

        imshow(CameraWindow, Camera);
        //   Mat image = cv::imread("test.png");// read the file
        //   namedWindow( "Display window", WINDOW_AUTOSIZE );// create a window for display.
        //   imshow( "Display window", image );// show our image inside it.

        printf("Frame : %d, HyperRAM: %s, ", J++, (DevStat[0]==0)?"OK":"FAIL");

        printf("Battery Voltage: %.2fV, ", (double)DevStat[6]*(1.8*169.8/69.8/255));

        int16_t Temperature = (int16_t)((uint16_t)DevStat[2])*256 + DevStat[1];
        int16_t Humidity    = (int16_t)((uint16_t)DevStat[4])*256 + DevStat[3];
        printf("Temp: %d.%uC, Humidity: %d.%u%, ", Temperature/10, Temperature%10, Humidity/10, Humidity%10);

        printf("IR Voltage: %.2fV, ", (((double)(DevStat[8]*256) + DevStat[9])*1.8)/65535);
        if (DevStat[10] == 0) printf("Tilt = OFF, ");
            else printf("Tilt = ON, ");
        if (DevStat[11] == 0) printf("NFC Field = OFF, ");
            else printf("NFC Field = ON, ");

        if (DevStat[7] == 0) printf("ModemStatus = Firmware_Boot, ");
        if (DevStat[7] == 1) printf("ModemStatus = Config_Commands, ");
        if (DevStat[7] == 2) printf("ModemStatus = Network_Registered, ");
        if (DevStat[7] == 3) printf("ModemStatus = FtpsServer_Login, ");
        if (DevStat[7] == 4) printf("ModemStatus = Command_Error, ");

        Tmp8Int = (int8_t)DevStat[12];
        printf("RSSI = %ddBm, ", Tmp8Int);

        if (DevStat[5] == 0) strcpy(RgbLedColor, "RED");
        if (DevStat[5] == 1) strcpy(RgbLedColor, "GREEN");
        if (DevStat[5] == 2) strcpy(RgbLedColor, "BLUE");
        if (DevStat[5] == 3) strcpy(RgbLedColor, "WHITE");
        printf("RgbLed: %s\n", RgbLedColor);

        KeyPress = waitKey(1);// wait for a keystroke in the window
        if (KeyPress == 27)
            break;
    }
    }
    else
    {
        SendCmd[0] = 0xF5;
        while (1)
        {
            printf("\nSensors list\n");
            printf(" 0 - Exit sensor address configuration\n");
            printf("--------------------------------------\n");
            printf(" 1 - Wind speed sensor (RDWSMASA)\n");
            printf(" 2 - Illumination sensor (ISRDWO01)\n");
            printf(" 3 - Photosynthetically sensor (RDPAS01)\n");
            printf(" 4 - UV radiation sensor (RDUVS01)\n");
            printf(" 5 - Air C2H4 sensor (RDC2H401)\n");
            printf("----------------------------------------\n");
            printf("20 - Soil 8 in 1 sensor (RDS8IN1)\n");
            printf("21 - Soil 4 in 1 sensor (SMTESPOV2)\n");
            printf("22 - Soil Ph Silver sensor (SPHAGRD)\n");
            printf("23 - Soil Ph sensor (China aliexpress)\n");
            printf("24 - Soil Multi parameter T/H/SAL/EC/NPK sensor (China aliexpress)\n");
            printf("25 - Soil Moisture Level2 sensor (China aliexpress)\n");
            printf("26 - Soil Moisture Level3 sensor (China aliexpress)\n");
            printf("27 - Soil Moisture Level4 sensor (China aliexpress)\n");
            printf("28 - Soil Moisture Level5 sensor (China aliexpress)\n");
            printf("29 - Soil Moisture Level6 sensor (China aliexpress)\n");
            printf("---------------------------------------------------\n");
            printf("40 - Soil CO2 sensor (SCO201)\n");
            printf("41 - Soil O2 sensor (SOR01)\n");
            printf("42 - Soil CH4 sensor (SC2H4R01)\n");
            printf("-------------------------------\n");
            printf("Input the sensor number: ");
            if (scanf("%d", &TmpInt) != 1) {printf("Set sensor address -> INVALID NUMBER(press enter)\n"); while (((TmpChar[0] = getchar()) != '\n') && (TmpChar[0] != EOF)); getchar(); continue;};
            if (TmpInt <= 0)    break;
            if ((TmpInt >= 60) || (SensorsAdress[TmpInt] == 0))         {printf("Set sensor address -> INVALID SENSOR (press enter)\n"); while (((TmpChar[0] = getchar()) != '\n') && (TmpChar[0] != EOF)); getchar(); continue;}
            SendCmd[1] = SensorsAdress[TmpInt];
            PurgeComm(hCom, PURGE_RXCLEAR);
            WriteFile(hCom, SendCmd, sizeof(SendCmd), &BytesWrite, 0);
            ReadFile(hCom, DevStat, 16, NULL, 0);
            if (DevStat[0] == 0)    printf("Set sensor address -> FAIL (press enter)\n");
            if (DevStat[0] == 1)    printf("Set sensor address -> OK (press enter)\n");
            if (DevStat[0] == 2)    printf("Set sensor address -> ALREADY SET (press enter)\n");
            while (((TmpChar[0] = getchar()) != '\n') && (TmpChar[0] != EOF));
            getchar();
        }
    }

    destroyAllWindows();
    return 0;
}
