<?php
session_start();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/ol@v7.1.0/ol.css">
<!-- Custom styles -->
<style>
	#DevicesMap {
		width: 100%;
		height: 500px;
  	}

	input[type=text], input[type=email], input[type=password] {
    	width: 100%;
    	padding: 8px 8px;
    	margin: 8px 0;
    	display: inline-block;
    	border: 1px solid #ccc;
    	box-sizing: border-box;
  	}

	input[type="checkbox"] {
		-webkit-appearance: none;
  		appearance: none;
  		background-color: #fff;
		border-radius: 8px;
  		margin: 0;
  		font: inherit;
  		color: currentColor;
  		width: 1.4em;
  		height: 1.4em;
  		border: 0.15em solid currentColor;
  		transform: translateY(-0.075em);
  		display: grid;
  		place-content: center;
	}

	input[type="checkbox"]::before {
  		content: "";
  		width: 0.90em;
  		height: 0.90em;
		border-radius: 4px;
  		transform: scale(0);
  		transition: 50ms transform ease-in-out;
  		box-shadow: inset 1em 1em red;
	}

	input[type="checkbox"]:checked::before {
  		transform: scale(1) !important;
	}

	.inputf {
		padding: 1px 0;
		background: #444;
		margin: 0;
	}
	.inputf ul {
		margin: 0;
		padding: 0;
	}
	.inputf li {
		list-style-type: none;
		display: inline-block;
		text-align: left;
		margin-bottom: 2px;
		font-size: 32px;
		font-weight: bold;
		color: white;
		-webkit-tap-highlight-color: rgba(0, 0, 0, 0);
		-webkit-tap-highlight-color: transparent;
		-webkit-touch-callout: none;
		-webkit-user-select: none;
		-khtml-user-select: none;
		-moz-user-select: none;
		-ms-user-select: none;
		user-select: none;
	}
	button {
		background-color: red;
		border: 2px;
		border-radius: 4px;
		color: white;
		padding: 5px 10px;
		text-align: center;
		text-decoration: none;
		display: inline-block;
		font-weight: bold;
		font-size: calc(0.75em + 1vmin);
	}
	#InsectButton {
		color:white;
		font-weight: bold;
		box-shadow: 2px 2px 2px black;
		background: red;	
	}
</style>

<link rel="stylesheet" href="style.css?a=987">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.6.0/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.0.1"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels@2.1.0"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/chartjs-plugin-annotation/2.1.0/chartjs-plugin-annotation.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/ol@v7.1.0/dist/ol.js"></script>
<script>
  var TempFreeze;
  var Temp = -400;
  var TimeClickHold = -1;
  var Interval;

  function updatefreezetempid() {
	document.getElementById('freezetempid').value = Temp;
  }
  function filldisplaytemp(Val) {
  	var Sign = "";
  	if (Val < 0) { Sign = "-"; Val = -Val;}
	document.getElementById('TempFreeze').innerHTML = Sign + Math.trunc(Val/10) + "." + Math.trunc(Val%10) + "°C";
  }
  function startinc() {
	TimeClickHold=0;
	Temp = Temp + 1;
	if (Temp > 600) Temp = 600;
	filldisplaytemp(Temp);
	updatefreezetempid();
  }
  function startdec() {
	TimeClickHold=0;
	Temp = Temp - 1;
	if (Temp < -400) Temp = -400;
	filldisplaytemp(Temp);
	updatefreezetempid();
  }
  function startincpress() {
	TimeClickHold=0;
	TempFreeze = setInterval(function() {
	if (TimeClickHold == -1) {clearInterval(TempFreeze); return;}
	TimeClickHold++;
	if (TimeClickHold > 30) Temp = Temp + 10;
	else if (TimeClickHold > 15) Temp = Temp + 5;
		else Temp = Temp + 1;
	if (Temp > 600) Temp = 600;
	filldisplaytemp(Temp);
	updatefreezetempid(); 	
    }, 100);
  }
  function startdecpress() {
	TimeClickHold=0;
	TempFreeze = setInterval(function() {
	if (TimeClickHold == -1) {clearInterval(TempFreeze); return;} 
	TimeClickHold++;
	if (TimeClickHold > 30) Temp = Temp - 10;
	else if (TimeClickHold > 15) Temp = Temp - 5;
		else Temp = Temp - 1;
	if (Temp < -400) Temp = -400;
	filldisplaytemp(Temp);
	updatefreezetempid();	
    }, 100);
  }
  function endpress() {
	TimeClickHold=-1;
	clearInterval(TempFreeze);
  }
  function updatefreezetempinit(Val) {
	Temp = Val;
  }

  function DisplayDevicesByName() {
  	var x = document.getElementById("DevicesDiv");
  	if (x.style.display === "none") 	x.style.display = "block";
  	else    							x.style.display = "none";
  }
 
  function DisplayAddUser() {
  	var x = document.getElementById("AddUserDiv");
  	if (x.style.display === "none") 	x.style.display = "block";
  	else    							x.style.display = "none";
  }

  function DisplayPictures() {
  	var x = document.getElementById("ImgSmallTableDiv");
  	if (x.style.display === "none") 	x.style.display = "";
  	else    							x.style.display = "none";
  }
  


</script> 
<link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700" rel="stylesheet">
</head>

<body onmouseup="endpress()" ontouchend="endpress()">
<?php
// include utils operations
include '/home/flytrapr/private_html/utils.php';

if (isset($_POST['uname']) && isset($_POST['psw']))
{
	$_SESSION['uname'] = null;
	$UserList = json_decode(file_get_contents("Users/UserList.json", true));
	$Users = $UserList->Users;
	foreach($Users as $UserData) {
		if (($_POST['uname'] == $UserData->Name) && password_verify($_POST['psw'], $UserData->Password))
		{
			$_SESSION['uname'] = $_POST['uname'];
			unset($_SESSION['device']);
			break;
		}
	}
}


if ($_SESSION['uname'])
{
	$User = $_SESSION['uname'];
	if (isset($_POST['AddUname']))
	{
		$AddUname = $_POST['AddUname'];
		lockf("/home/flytrapr/private_html/lockf/UserList.lk"); 
		$UsersPassData = json_decode(file_get_contents('Users/UserList.json', true));
		foreach($UsersPassData->Users as $UserPassData)
			if ($UserPassData->Name == $AddUname)
			{
				$DisplayUserExist = 1;
				break;
			}

		if (!$DisplayUserExist)
		{
			$UserData = json_decode(file_get_contents("Users/$User.json", true));
			if (isset($UserData->Users))
				$UserData->Users[] = $AddUname;
			else
			{
				$NewUser = array();
				$NewUser[] = $AddUname;
				$UserData->Users = $NewUser;
			}
			file_put_contents("Users/$User.json", json_encode($UserData, JSON_PRETTY_PRINT));
	
			$UserData->Type = 'User';
			$UserData->User = $AddUname;
			$UserData->Mail = $_POST['AddMail'];
			unset($UserData->Users);
			file_put_contents("Users/$AddUname.json", json_encode($UserData, JSON_PRETTY_PRINT));
			
			
			$UsersPassData->Users[] = (object)['Name'=>$AddUname, 'Password'=>password_hash($_POST['AddPsw'], PASSWORD_DEFAULT), 'Mode'=>'Old'];
			file_put_contents('Users/UserList.json', json_encode($UsersPassData, JSON_PRETTY_PRINT));
		}
		unlockf("/home/flytrapr/private_html/lockf/UserList.lk"); 
		$DisplayAddUsers = 1;								
	}

	if (isset($_POST['RemUsers']))
	{
		lockf("/home/flytrapr/private_html/lockf/UserList.lk"); 
		$UserData = json_decode(file_get_contents("Users/$User.json", true));
		$UsersPassData = json_decode(file_get_contents('Users/UserList.json', true));
		foreach($_POST['RemUsers'] as $RemUser)
		{
			$RemUserA = explode('`', $RemUser);
			$RemUserIdx = $RemUserA[0]; $RemUserName = $RemUserA[1];
			if ($UserData->Users[$RemUserIdx] == $RemUserName)
			{
				unset($UserData->Users[$RemUserIdx]);
				unlink("Users/$RemUserName.json");
	
				$I = 0;
				foreach($UsersPassData->Users as $UserPassData)
				{
					if ($UserPassData->Name == $RemUserName)
					{
						unset($UsersPassData->Users[$I]);
						break;
					}
					$I++;
				}
			}
		}
		$UserData->Users = array_values($UserData->Users);
		$UsersPassData->Users = array_values($UsersPassData->Users);
		file_put_contents("Users/$User.json", json_encode($UserData, JSON_PRETTY_PRINT));
		file_put_contents('Users/UserList.json', json_encode($UsersPassData, JSON_PRETTY_PRINT));
		unlockf("/home/flytrapr/private_html/lockf/UserList.lk"); 
		$DisplayAddUsers = 1;	
	}
	
	// Get the user/devices association
	$Year = date("Y");
	$UserData = $DevicesList = json_decode(file_get_contents("Users/".$User.".json", true));
	$DevicesGps = json_decode(file_get_contents("php/LastGpsPositions.json", true), true);

	$UserType = 'User';
	if (isset($UserData->Type))
		$UserType = $UserData->Type;
	?>
	
	<!--  Build the devices list -->
	
	<div style="overflow-wrap: break-word">
	<a href="displays.php?home=1"><span class="devfont" style="border: 2px; border-radius: 4px; font-size: 140%">Home</span></a>&nbsp&nbsp
	<a href="#" onclick="DisplayDevicesByName()"><span class="devfont" style="border: 2px; border-radius: 4px; font-size: 140%">Devices</span></a>&nbsp&nbsp
	<a href="#" onclick="DisplayDevicesMap()"><span class="devfont" style="border: 2px; border-radius: 4px; font-size: 140%">Map</span></a>&nbsp&nbsp
	<?php
		if (($UserType == 'SuperUser') || ($UserType == 'Admin'))
			echo '<a href="#" onclick="DisplayAddUser()"><span class="devfont" style="border: 2px; border-radius: 4px; font-size: 140%">Users</span></a>&nbsp&nbsp';
	?>
	<a href="index.html"><span class="devfont" style="border: 2px; border-radius: 4px; font-size: 140%">Logout</span></a>
	</div>

	<?php
		if ($DisplayAddUsers)	echo '<div id="AddUserDiv" style="display: block">';
		else					echo '<div id="AddUserDiv" style="display: none">';
	?>
		<hr/>
		<form method="post" action="displays.php">
			<div class="inputf">
			<?php
				if ($DisplayUserExist) echo '<ul><li style="color: red">User already exists!!!</li></ul>';
			?>
			<ul><li style="width: 88.0%">	
			<ul><li style="width: 1.0%"></li>
			<li style="width: 29.0%"><label for="AddUname"><strong>Username</strong></label></li>
			<li style="width: 29.0%"><label for="AddMail"><strong>Email</strong></label></li>
			<li style="width: 29.0%"><label for="AddPsw"><strong>Password</strong></label></li></ul>
			<ul><li style="width: 1.0%"></li><li style="width: 29.0%"><input type="text" placeholder="User" name="AddUname" autocomplete="new-user" required></li>
			<li style="width: 29.0%"><input type="email" placeholder="Email" pattern="[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Za-z]{1,63}$" name="AddMail" autocomplete="new-mail" required></li>
			<li style="width: 29.0%"><input type="password" placeholder="Password" name="AddPsw" autocomplete="new-password" required></li></ul>
			</li><li style="width: 12.0%"><button type="submit" style="font-size: 140%">Add</button></li>
			</ul></div>
		</form>
		<?php
			if (isset($UserData->Users) && count($UserData->Users))
			{	echo '<form method="post" action="displays.php"><div class="inputf"><ul><li style="width: 88.0%">';
				$I = 0;
				foreach($UserData->Users as $User)
				{
					$SubUser = json_decode(file_get_contents("Users/".$User.".json", true));
					echo '<ul><li style="width: 1.0%"></li><li style="width: 10.0%"><input type="checkbox" name="RemUsers[]" value="'.$I.'`'.$User.'"></li><li>';
					echo "$User&nbsp&nbsp&nbsp ($SubUser->Mail)";
					echo '</li></ul>';
					$I++;
				}
				echo '<ul><li style="width: 11.0%"></li>';
				echo '<li style="width: 80.0%"><button type="submit" style="font-size: 140%">RemoveSelectedUsers</button></li></ul>';
				echo '</li></ul></div></form>';
			}
		?>
		
	</div>

	<?php
	echo '<div id="DevicesDiv" style="display: none">';
	echo '<hr/>';
	for($I=0; $I<count($DevicesList->Devices); $I++)
	{
		$Device=$DevicesList->Devices[$I];
		echo '<a href="displays.php?device='.$I.'"><span class="devfont" style="background-color: red; border: 2px; border-radius: 4px">'.$Device->DeviceName.'</span></a>&nbsp&nbsp ';
	}
	echo '</div>';
	?>

	<div id="DevicesMapDelimiter" style="display: none"><hr/></div>
	<div id="DevicesMap" style="display: none"></div>
	<script>
		var layer  = new ol.layer.Tile();
		var source = new ol.source.OSM();
		var urls = source.getUrls();
    	var projection = source.getProjection();
       	var attributions = source.getAttributions2 ? source.getAttributions2() : source.getAttributions();                        
		if (attributions)
			attributions = attributions.bind(source); 
        var grid = source.getTileGrid();
    	var resolutions = grid.getResolutions().slice(); // take a copy, leave original source unaltered for the WMS tileUrlFunction
    	var origins = [];
    	var tileSizes = [];
    	for (var i = 0; i < resolutions.length; i++) {
        	origins[i] = grid.getOrigin(i);
        	tileSizes[i] = grid.getTileSize(i);
        	if (!Array.isArray(tileSizes[i]))
            	tileSizes[i] = [tileSizes[i], tileSizes[i]];
        	if (/iPhone|iPad|iPod|Android/i.test(navigator.userAgent)) {
				const scaling = 2; 
            	tileSizes[i][0] = tileSizes[i][0] * scaling;
            	tileSizes[i][1] = tileSizes[i][1] * scaling;
            	resolutions[i] = resolutions[i] / scaling;
			}
        }
    
    	var tileUrlFunction = source.getTileUrlFunction().bind(source);  // bind needed if custom functions use 'this'
    	var source2 = new ol.source.XYZ({
        	urls: urls,
        	projection: projection,
        	attributions: attributions,
        	tileGrid: new ol.tilegrid.TileGrid({
                resolutions: resolutions,
                tileSizes: tileSizes,
                origins: origins,
            }),
        	tileUrlFunction: tileUrlFunction  // essential for Bing, WMS and WMTS but is valid for all
    	});
    	source2.set("originalSource", source);  // makes the WMS/WMTS parameters accessible if required
    	layer.setSource(source2);
		
		var map = new ol.Map({
        	controls: [new ol.control.FullScreen()],
        	interactions: ol.interaction.defaults.defaults({altShiftDragRotate:false, pinchRotate:false}),
        	target: 'DevicesMap',
        	renderer: 'canvas',
        	layers: [layer],
        	view: new ol.View({
        		center: ol.proj.transform([0, 0], 'EPSG:4326', 'EPSG:3857'),
            	zoom: 10,
            	maxZoom: 20,
        	})
        });

		// Geometries
		<?php
			echo "const GeoJSON = {\n\"type\": \"FeatureCollection\",\n\"features\": [\n";
			$I=0;
			foreach($DevicesList->Devices as $DeviceT)
			{
				$DeviceGps	= $DevicesGps[$DeviceT->DeviceId];
				if ($DeviceGps['GPS'] != "N/A")
				{
					echo "{\n\"type\": \"Feature\",\n\"properties\": {\nname:\"$DeviceT->DeviceName\",\nidx: $I,\ntype: \"Device\",\nstyle:\"";
					if (strtotime($DeviceGps['GPSTime']) >= strtotime('-5 days'))
					{
						if ($DeviceGps['DevType'] == "S")		echo '1';
						elseif ($DeviceGps['DevType'] == "I")	echo '2';
						elseif ($DeviceGps['DevType'] == "C")	echo '3';
					}
					else									echo '0';
					echo "\"\n},\n";
					$GpsPos = $DeviceGps['GPS'];
					echo "\"geometry\": {\n\"coordinates\": [$GpsPos],\n\"type\": \"Point\"\n}\n},\n";
				}
				$I++;
			}
			echo "]\n};\n";
		?>

		const vectorSource = new ol.source.Vector({
  			features: new ol.format.GeoJSON().readFeatures(GeoJSON, {dataProjection: 'EPSG:4326', featureProjection: 'EPSG:3857'}),
		});


		var DevFlyInactiveImage = new ol.style.Circle({
  			stroke: new ol.style.Stroke({color: ' dimgrey', width: 4}),
  			fill: new ol.style.Fill({color: 'rgba(255,255,255,0.8)'}),
  			radius: 12,
		});
		var DevFlyImage = new ol.style.Circle({
  			stroke: new ol.style.Stroke({color: 'red', width: 4}),
  			fill: new ol.style.Fill({color: 'rgba(255,255,255,0.8)'}),
  			radius: 12,
		});
		var DevSensorImage = new ol.style.Circle({
  			stroke: new ol.style.Stroke({color: 'blue', width: 4}),
  			fill: new ol.style.Fill({color: 'rgba(255,255,255,0.8)'}),
  			radius: 12,
		});
		var DevCombinedImage = new ol.style.Circle({
  			stroke: new ol.style.Stroke({color: 'purple', width: 4}),
  			fill: new ol.style.Fill({color: 'rgba(255,255,255,0.8)'}),
  			radius: 12,
		});

		var DevMarkerStyle = [
			new ol.style.Style({image: DevFlyInactiveImage}),
			new ol.style.Style({image: DevSensorImage}),
			new ol.style.Style({image: DevFlyImage}),
			new ol.style.Style({image: DevCombinedImage})
		];

		var StyleFunction = function(feature) {
			var zoom = map.getView().getZoom();
			var font_size = 14;
			var stroke_size = 6;
			if (/iPhone|iPad|iPod|Android/i.test(navigator.userAgent))
			{
				if (zoom < 9) font_size = 14;
				else font_size = Math.min(14 + 6*(zoom-9), 36);
				stroke_size = 6 + ((zoom-9)/2);
			}
			var labelStyle = new ol.style.Style({
				text: new ol.style.Text({
					font: font_size +'px Calibri,sans-serif',
					overflow: true,
					fill: new ol.style.Fill({
						color: 'white'
					}),
					stroke: new ol.style.Stroke({
						color: 'black',
						width: stroke_size
					}),
				offsetY: -20-((font_size-14)/2)
				})
			});
    		if (zoom > 7)  labelStyle.getText().setText(feature.get('name'));
    		else labelStyle.getText().setText('');
  			return [DevMarkerStyle[feature.get('style')], labelStyle];
		};

		// Vector layer
		var vectorLayer = new ol.layer.Vector({
			source: vectorSource,
			style: StyleFunction,
			updateWhileAnimating: true,
			updateWhileInteracting: true
		});
		// Add Vector layer to map
		map.addLayer(vectorLayer);
	
		var Index;
		map.on('click', function(evt) {
  			if (map.forEachFeatureAtPixel(evt.pixel,
    			function(feature) {
	  				Index = feature.get('idx');	
      				return feature.get('type') == "Device";
    			}))
    			window.location.href = 'https://flytrap.ro/displays.php?map=1&device='+Index;
		});

		<?php
			if (isset($_GET['map']))
			{
		?>
				var x = document.getElementById("DevicesMap");
				x.style.display = "block";
				document.getElementById("DevicesMapDelimiter").style.display = "block";
  				map.setTarget(x);
				map.updateSize();
		<?php
				if (isset($_GET['device']))
				{
					$GpsPosTmp = $DevicesGps[$DevicesList->Devices[$_GET['device']]->DeviceId]['GPS'];
					if ($GpsPosTmp == "N/A")	unset($GpsPosTmp);
				}
				if (isset($GpsPosTmp))	echo "map.getView().setCenter(ol.proj.transform([$GpsPosTmp], 'EPSG:4326', 'EPSG:3857')); map.getView().setZoom(8);";
				else					echo 'map.getView().fit(vectorLayer.getSource().getExtent(), {size: map.getSize(), padding:[100,100,100,100], maxZoom: 10});';
			};
		?>
    </script>

	<?php
	if (isset($_GET['home']))
		unset ($_SESSION['device']);
	if (isset($_GET['device']))
	{
		$Dev = $_SESSION['device'] = $_GET['device'];
		unset($_SESSION['year']); unset($_SESSION['month']); unset($_SESSION['day']);
	}
	else
	{
		if (isset($_SESSION['device']))
			$Dev = $_SESSION['device'];
		else
		{
			$Dev = 0;
			unset($_SESSION['year']); unset($_SESSION['month']); unset($_SESSION['day']);
		}
	}
	$Device = $DevicesList->Devices[$Dev];

	$PathDevice = $Device->DeviceId;
	if (isset($_POST['freezetemp']))
		file_put_contents($PathDevice."/firmware/cnf.txt", "A_FreezeThreshold=".$_POST['freezetemp']."\r\n");

	if (isset($_GET['day']))
	{
		$_SESSION['day'] = $_GET['day'];
		$_SESSION['month'] = $_GET['month'];
		$_SESSION['year'] = $_GET['year'];
	}
	elseif (isset($_GET['month']))
	{
		$_SESSION['month'] = $_GET['month'];
		$_SESSION['year'] = $_GET['year'];
		unset($_SESSION['day']);
	}
	elseif (isset($_GET['year']))
	{
		$_SESSION['year'] = $_GET['year'];
		unset($_SESSION['month']);
		unset($_SESSION['day']);
	}

	if (isset($_GET['insect']))
		$ActiveInsect = $_GET['insect'];

	lockf("/home/flytrapr/private_html/lockf/$PathDevice-pic.lk");
	$DevPictures = glob($PathDevice."/*.jpg");
	rsort($DevPictures);
	$PicsList = array();
	if (empty($DevPictures))
		unlink("/home/flytrapr/private_html/$PathDevice/pics.json");
	else
	{
		if ($JsonFile = file_get_contents("/home/flytrapr/private_html/$PathDevice/pics.json", true))
		{
			$PicsList = json_decode($JsonFile, true);
			$NewestPic = key($PicsList);
			if ($NewestPic != substr(pathinfo($DevPictures[0], PATHINFO_FILENAME), 0, 20))
			{
				foreach($DevPictures as $DevPic)
				{
					$DevPicDate = substr(pathinfo($DevPic, PATHINFO_FILENAME), 0, 20);
					if ($DevPicDate <= $NewestPic)	break;
					[$Weight, $Height] = getjpegsize($DevPic);
					$PicsListUpdate[$DevPicDate] = $Weight.'x'.$Height;
				}
				$PicsList = $PicsListUpdate + $PicsList;
				$PicsUpdated = true;
			}
			$I = 0;
			if (count($PicsList) != count($DevPictures))
			{
				// Some pictures where deleted
				foreach($PicsList as $Key=>$Value)
					if ($Key == substr(pathinfo($DevPictures[$I], PATHINFO_FILENAME), 0, 20))
						$I++;
					else
						unset($PicsList[$Key]);
				$PicsUpdated = true;
			}
		}
		else
			foreach($DevPictures as $DevPic)
			{
				$DevPicDate = substr(pathinfo($DevPic, PATHINFO_FILENAME), 0, 20);
				[$Weight, $Height] = getjpegsize($DevPic);
				$PicsList[$DevPicDate] = $Weight.'x'.$Height;
				$PicsUpdated = true;
			}
		if ($PicsUpdated)
		{
			if (!is_dir("/home/flytrapr/private_html/$PathDevice"))
				mkdir("/home/flytrapr/private_html/$PathDevice");
			file_put_contents("/home/flytrapr/private_html/$PathDevice/pics.json", json_encode($PicsList, JSON_PRETTY_PRINT));
		}
	}
	unlockf("/home/flytrapr/private_html/lockf/$PathDevice-pic.lk");

	
	lockf("/home/flytrapr/private_html/lockf/$PathDevice-stat.lk");
	$DevStatus = glob($PathDevice."/status/*.txt");
	rsort($DevStatus);

	$StatusList = array();
	if (empty($DevStatus))
		unlink("/home/flytrapr/private_html/$PathDevice/stats.json");
	else
	{
		if ($JsonFile = file_get_contents("/home/flytrapr/private_html/$PathDevice/stats.json", true))
		{
			$StatusList = json_decode($JsonFile, true);
			$NewestStat = key($StatusList);
			if ($NewestStat != substr(pathinfo($DevStatus[0], PATHINFO_FILENAME), 0, 20))
			{
				foreach($DevStatus as $DevStat)
				{
					$DevStatDate = substr(pathinfo($DevStat, PATHINFO_FILENAME), 0, 20);
					if ($DevStatDate <= $NewestStat)	break;
					$StatusListUpdate[$DevStatDate] = file_get_contents($DevStat, true);
				}
				$StatusList = $StatusListUpdate + $StatusList;
				$StatsUpdated = true;
			}
			$I = 0;
			if (count($StatusList) != count($DevStatus))
			{
				// Some status where deleted
				foreach($StatusList as $Key=>$Value)
					if ($Key == substr(pathinfo($DevStatus[$I], PATHINFO_FILENAME), 0, 20))
						$I++;
					else
						unset($StatusList[$Key]);
				$StatsUpdated = true;
			}
		}
		else
			foreach($DevStatus as $DevStat)
			{
				$DevStatDate = substr(pathinfo($DevStat, PATHINFO_FILENAME), 0, 20);
				$StatusList[$DevStatDate] = file_get_contents($DevStat, true);
				$StatsUpdated = true;
			}
		if ($StatsUpdated)
		{
			if (!is_dir("/home/flytrapr/private_html/$PathDevice"))
				mkdir("/home/flytrapr/private_html/$PathDevice");
			$TmpString = json_encode($StatusList, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES);
			file_put_contents("/home/flytrapr/private_html/$PathDevice/stats.json", $TmpString);
			$StatusList = json_decode($TmpString, true);
		}
	}
	unlockf("/home/flytrapr/private_html/lockf/$PathDevice-stat.lk");


	$LastDate = substr(pathinfo($DevStatus[0], PATHINFO_FILENAME), 0, 10);
	if (isset($_SESSION['day']))
	{
		$DateYear = $_SESSION['year'];
		$DateMonth = $_SESSION['month'];
		$DateDay = $_SESSION['day'];
		if ($DateDay<32)
			$DateStrB = $DateStrE = $DateYear.'-'.$DateMonth.'-'.str_pad($DateDay, 2, '0', STR_PAD_LEFT);
		elseif ($DateDay<64)
		{
			$DateStrB = $DateYear.'-'.$DateMonth.'-'.str_pad($DateDay-32, 2, '0', STR_PAD_LEFT);
			$DateStrE = date('Y-m-d', strtotime("+6 days", strtotime($DateStrB)));
			if (strcmp($DateStrE, $LastDate) > 0)
			{
				$DateStrE = $LastDate;
				$DateStrB = date('Y-m-d', strtotime("-6 days", strtotime($DateStrE)));
			}
		}
		else
		{
			$DateStrE = $DateYear.'-'.$DateMonth.'-'.str_pad($DateDay-64, 2, '0', STR_PAD_LEFT);
			if (strcmp($DateStrE, $LastDate) > 0)
				$DateStrE = $LastDate;
			$DateStrB = date('Y-m-d', strtotime("-13 days", strtotime($DateStrE)));
		}
	}
	elseif (isset($_SESSION['month']))
	{
		$DateYear = $_SESSION['year'];
		$DateMonth = $_SESSION['month'];
		$DateDay = '01';
		$DateStrB = $DateYear.'-'.$DateMonth.'-'.$DateDay;
		$DateStrE = date("Y-m-t", strtotime($DateStrB));
	}
	elseif (isset($_SESSION['year']))
	{
		$DateYear = $_SESSION['year'];
		$DateMonth = '01';
		$DateDay = '01';
		$DateStrB = $DateYear.'-01-01';
		$DateStrE = $DateYear.'-12-31';
	}
	else
	{
		$File = pathinfo($DevStatus[0], PATHINFO_FILENAME);
		$DateStrB = $DateStrE = explode("_", $File)[0];
		[$DateYear, $DateMonth, $DateDay] = explode('-', $DateStrB);
	}
	$DateStr = $DateYear.'-'.$DateMonth.'-'.$DateDay;

	$DateStartStatusIdx = -1;
	$DateStrStatB = $DateStrStatE = "1900-01-01";
	$I=0;
	foreach($DevStatus as $File)
	{
		$File = substr(pathinfo($File, PATHINFO_FILENAME), 0, 10);
		if (strcmp($File, $DateStrB) < 0)
			break;
		if ($DateStartStatusIdx >= 0)
			$DateEndStatusIdx++;
		else
		{
			if ((strcmp($File, $DateStrE) <= 0) && (strcmp($File, $DateStrB) >= 0))
			{
				$DateStartStatusIdx = $I;
				$DateEndStatusIdx = $I;
				$DateStrStatE = $File;
				[$DateYearStatE, $DateMonthStatE, $DateDayStatE] = explode("-", $DateStrStatE);
			}
		}
		$FileP = $File;
		$I++;
	}
	if ($DateStartStatusIdx >= 0)
	{
		$DateStrStatB = $FileP;
		[$DateYearStatB, $DateMonthStatB, $DateDayStatB] = explode("-", $DateStrStatB);
	}

	$DateStartPicturesIdx = -1;
	$DateStrPicB = $DateStrPicE = "1900-01-01";	
	$I=0;
	foreach($DevPictures as $File)
	{
		$File = substr(pathinfo($File, PATHINFO_FILENAME), 0, 10);
		if (strcmp($File, $DateStrB) < 0)
			break;
		if ($DateStartPicturesIdx >= 0)
			$DateEndPicturesIdx++;
		else
		{
			if ((strcmp($File, $DateStrE) <= 0) && (strcmp($File, $DateStrB) >= 0))
			{
				$DateStartPicturesIdx = $I;
				$DateEndPicturesIdx = $I;
				$DateStrPicE = $File;
				[$DateYearPicE, $DateMonthPicE, $DateDayPicE] = explode("-", $DateStrPicE);
			}
		}
		$FileP = $File;
		$I++;
	}
	if ($DateStartPicturesIdx >= 0)
	{
		$DateStrPicB = $FileP;
		[$DateYearPicB, $DateMonthPicB, $DateDayPicB] = explode("-", $DateStrPicB);
	}
	
	if (($DateStartStatusIdx >= 0) && ($DateStartPicturesIdx >= 0))
		$DateStr = (strcmp($DateStrPicE, $DateStrStatE) > 0) ? $DateStrPicE:$DateStrStatE;
	elseif ($DateStartStatusIdx >= 0)
		$DateStr = $DateStrStatE;
	elseif ($DateStartPicturesIdx >= 0)
		$DateStr = $DateStrPicE;

	$DaysData = array_fill(0, 32, 0);
	$DateYME = substr($DateStr, 0, 7);
	foreach($DevStatus as $File)
	{
		$File = pathinfo($File, PATHINFO_FILENAME);
		$DateYM = substr($File, 0, 7);
		$Flag = strcmp($DateYM, $DateYME);
		if ($Flag < 0)			break;
		elseif ($Flag == 0)		$DaysData[intval(substr($File, 8, 2))] = 1;
	}
	foreach($DevPictures as $File)
	{
		$File = pathinfo($File, PATHINFO_FILENAME);
		$DateYM = substr($File, 0, 7);
		$Flag = strcmp($DateYM, $DateYME);
		if ($Flag < 0)			break;
		elseif ($Flag == 0)		$DaysData[intval(substr($File, 8, 2))] = 2;
	}
		
	[$DateYear, $DateMonth, $DateDay] = explode("-", $DateStr);
	$FirstDayInWeek = date('N', strtotime($DateYear."-".$DateMonth."-01"));
	$DaysInMonth = date('t', strtotime($DateYear."-".$DateMonth."-01"));

	echo '<hr/><div class="month"><ul><li class="prev">';
	if (intval($DateMonth) > 1)
		echo '<a href="displays.php?year='.$DateYear.'&month='.str_pad(intval($DateMonth)-1, 2, '0', STR_PAD_LEFT).'">&#10094;&#10094;&#10094;-1M</a>';
	else
		echo '<a href="displays.php?year='.($DateYear-1).'&month=12">&#10094;&#10094;&#10094;-1M</a>';
	echo '</li><li class="next">';
	if (intval($DateMonth) < 12)
		echo '<a href="displays.php?year='.$DateYear.'&month='.str_pad(intval($DateMonth)+1, 2, '0', STR_PAD_LEFT).'">+1M&#10095;&#10095;&#10095;</a>';
	else
		echo '<a href="displays.php?year='.($DateYear+1).'&month=01">+1M&#10095;&#10095;&#10095;</a>';	
	echo '</li><li>Device name: '.$Device->DeviceName.'<br>';
	echo '<span style="box-shadow: 2px 2px 2px black;';
	if (isset($_SESSION['month']) && !isset($_SESSION['day'])) echo 'border: 6px solid black; border-radius: 15px';
	echo '"><a href="displays.php?year='.$DateYear.'&month='.$DateMonth.'">'.date('F', mktime(0, 0, 0, $DateMonth, 10)).'</a></span>&nbsp';
	echo '<span style="box-shadow: 2px 2px 2px black;';
	if (isset($_SESSION['year']) && !isset($_SESSION['month']) && !isset($_SESSION['day'])) echo 'border: 6px solid black; border-radius: 15px';
	echo '"><a href="displays.php?year='.$DateYear.'">'.$DateYear.'</a></span></li></ul></div>';
	echo '<ul class="weekdays"><li> </li><li>Mo</li><li>Tu</li><li>We</li><li>Th</li><li>Fr</li><li>Sa</li><li>Su</li>';
	echo '<li><a href="xlss.php?sel='.$PathDevice.'/status/'.$DateYear.'-'.$DateMonth.'-*.txt"><b>XLSS</b></a></li></ul>';
	echo '<ul class="days">';
	
	if ($FirstDayInWeek != 1)
	{
		echo '<li><a href = "displays.php?year='.$DateYear.'&month='.$DateMonth.'&day=33"><span class="week">&nbsp1W&nbsp</span></a></li>';
		for ($I=1; $I<$FirstDayInWeek; $I++) echo '<li>&nbsp</li>';
	}
	for ($I=1; $I<=$DaysInMonth; $I++)
	{
		$DateStrCurrent = $DateYear.'-'.$DateMonth.'-'.str_pad($I, 2, '0', STR_PAD_LEFT);
		$DateSelectedFlag = ((strcmp($DateStrCurrent, $DateStrStatB) >= 0) && (strcmp($DateStrCurrent, $DateStrStatE) <= 0)) ||
							((strcmp($DateStrCurrent, $DateStrPicB) >= 0) && (strcmp($DateStrCurrent, $DateStrPicE) <= 0));
		if ($FirstDayInWeek == 1)
			echo '<li><a href = "displays.php?year='.$DateYear.'&month='.$DateMonth.'&day='.str_pad($I+32, 2, '0', STR_PAD_LEFT).'"><span class="week">&nbsp1W&nbsp</span></a></li>';
		if ($DateSelectedFlag)
			echo '<li style="background-image: repeating-linear-gradient(to bottom, transparent 0 10%, #ccc 10% 90%)">';
		else
			echo '<li>';
		if ($DaysData[$I] == 2)
		{
			echo '<a href = "displays.php?year='.$DateYear.'&month='.$DateMonth.'&day='.str_pad($I, 2, '0', STR_PAD_LEFT).'"><span class="warning"';
			if ($DateSelectedFlag)
				echo ' style="border: 6px solid black; border-radius: 15px"';
			echo '>'.str_pad($I, 2, '0', STR_PAD_LEFT).'</span></a>';
		}
			elseif ($DaysData[$I] == 1)
			{
				echo '<a href = "displays.php?year='.$DateYear.'&month='.$DateMonth.'&day='.str_pad($I, 2, '0', STR_PAD_LEFT).'"><span class="data"';
				if ($DateSelectedFlag)
					echo ' style="border: 6px solid black; border-radius: 15px"';
				echo '>'.str_pad($I, 2, '0', STR_PAD_LEFT).'</span></a>';
			}
				else
				{
					echo '<span class="nothing"';
					if ($DateSelectedFlag)
						echo ' style="border: 6px solid black; border-radius: 15px"';
					echo '>'.str_pad($I, 2, '0', STR_PAD_LEFT).'</span>';
				}
		echo '</li>';
		$FirstDayInWeek++;
		if ($FirstDayInWeek == 8)
		{
			echo '<li><a href = "displays.php?year='.$DateYear.'&month='.$DateMonth.'&day='.str_pad($I+64, 2, '0', STR_PAD_LEFT).'"><span class="week">&nbsp2W&nbsp</span></a></li>';
			$FirstDayInWeek = 1;
		}
		
	}
	if ($FirstDayInWeek != 1)
	{
		for ($J=0; $J<(8-$FirstDayInWeek); $J++) echo '<li>&nbsp</li>';
		echo '<li><a href = "displays.php?year='.$DateYear.'&month='.$DateMonth.'&day='.str_pad($I+63, 2, '0', STR_PAD_LEFT).'"><span class="week">&nbsp2W&nbsp</span></a></li>';
	}
	echo '</ul><hr/>';


	if ($DateStartPicturesIdx >= 0)
	{
		$Insects = array();
		for($I = $DateStartPicturesIdx; $I <= $DateEndPicturesIdx; $I++)
		{
			$FileName = pathinfo($DevPictures[$I], PATHINFO_FILENAME);
			$Arr = explode("_", $FileName);
			for ($J=2; $J<count($Arr); $J++)
				if ($Arr[$J] != "Unknown")
					$Insects[$Arr[$J]]++;
		}
		echo '<div class="month"><ul><li>Insects images ('.($DateEndPicturesIdx-$DateStartPicturesIdx+1).')</li></ul></div><hr/>';
		echo '<div style="overflow-wrap: break-word">';
		if (isset($ActiveInsect))
		{
			echo "<span id='InsectButton'";
			if ($ActiveInsect == 'all')		echo " style='border: 6px solid black; border-radius: 15px'";
			echo "><a href='displays.php'>HideAll</a></span>&nbsp&nbsp";
		}
		else
			echo "<span id='InsectButton'><a href='displays.php?insect=all'>DisplayAll(".($DateEndPicturesIdx-$DateStartPicturesIdx+1).")</a></span>&nbsp&nbsp";
		foreach($Insects as $key => $value)
		{
			echo "<span id='InsectButton'";
			if ($key == $ActiveInsect)		echo " style='border: 6px solid black; border-radius: 15px'";
			echo "><a href='displays.php?insect=$key'>$key($value)</a></span>&nbsp&nbsp";
		}
		echo '</div>';

		if (isset($ActiveInsect))	echo '<hr/>';
		echo '<div id="ImgSmallTableDiv" style="width: 100%">';
		if (isset($ActiveInsect))
		{
			for($I = $DateStartPicturesIdx; $I <= $DateEndPicturesIdx; $I++)
			{
				$FileName = pathinfo($DevPictures[$I], PATHINFO_FILENAME);
				if ($ActiveInsect != 'all')
					if (strpos($FileName, $ActiveInsect) === false)
						continue;
				[$Width, $Height] = explode('x', $PicsList[substr($FileName, 0, 20)]);
				echo "<div><img class='image' width ='$Width' height='$Height' src='$DevPictures[$I]' loading='lazy'><br>";
				$Arr = explode("_", $FileName);
				if ($DateStrB != $DateStrE)
				{
					echo substr($FileName, 8, 2).'/'.substr($FileName, 5, 2).'/'.substr($FileName, 2, 2);
					if ($Width >= 240)	echo ' ';
					else				echo '<br>';
				}
				echo preg_replace('~[hm]~',':',substr($Arr[1],0,-1)).'<br>';
				
				$CountInsect = count($Arr);
				$InsectNotFound = true;
				for ($J=2; $J<count($Arr); $J++)
					if ($Arr[$J] != 'Unknown')
						{echo "<span class='atfont'>$Arr[$J] </span>"; $InsectNotFound = false;}
				if ($InsectNotFound)
					echo 'Unknown';
				echo '</div>';
			}
		}
		echo '</div><hr/>';
		if ((!empty($Insects)) && ($DateStrPicB != $DateStrPicE))
		{
			include '/home/flytrapr/private_html/insects.php';
		}
	}

	// Check if there is data to display
	if ($DateStartStatusIdx >= 0)
	{
		// Display sensors data
		include '/home/flytrapr/private_html/sensors.php';
	
		// Display GPS position
		echo '<hr/><div class="month"><ul><li><span class="maps-link">GPS position ';
		$StatusTxt = file_get_contents($DevStatus[$DateStartStatusIdx]);
		$Line = strtok($StatusTxt, "\r\n");
		while ($Line !== false)
		{
			if (strpos($Line, "GPS position") !== false)
			{
				if (strpos($Line, "N/A") === false)
				{
					echo '(click here to see the map)<br>';
					$Arr = explode(" ", $Line);
					$ArrGps = explode(",", $Arr[2]);
					$Latitude = floatval(substr($ArrGps[0], 0, -1));
					$Longitude = floatval(substr($ArrGps[1], 0, -1));	
					$Altitude = floatval(substr($ArrGps[2], 0, -1)); 	
					
					$Tmp = $Latitude;
					echo floor($Tmp).'°N ';
					$Tmp = $Tmp - floor($Tmp);
					$Tmp = $Tmp*60;
					echo floor($Tmp)."' ";
					$Tmp = $Tmp - floor($Tmp);
					$Tmp = $Tmp*60;
					echo round($Tmp).'"  &nbsp;&nbsp;&nbsp&nbsp;&nbsp;&nbsp';
				
					$Tmp = $Longitude;
					echo floor($Tmp).'°E ';
					$Tmp = $Tmp - floor($Tmp);
					$Tmp = $Tmp*60;
					echo floor($Tmp)."' ";
					$Tmp = $Tmp - floor($Tmp);
					$Tmp = $Tmp*60;
					echo round($Tmp).'"  &nbsp;&nbsp;&nbsp&nbsp;&nbsp;&nbsp';
					echo floor($Altitude).'m altitude';

					echo '</span></li></ul></div><br><div class="gmap_canvas"></div>';	
				
					echo "<script> $('.maps-link').click(function(){ $('.gmap_canvas').html('";
					echo '<iframe width="100%" height="500" id="gmap_canvas" src="https://maps.google.com/maps?q=';
					echo $ArrGps[0].','.$ArrGps[1];
					echo '&t=k&z=14&ie=UTF8&iwloc=&output=embed" frameborder="0" scrolling="no" marginheight="0" marginwidth="0"></iframe>';
					echo "');}); </script>";	
				}
				else
					$Line = false; 
				break;
			}
			$Line = strtok("\r\n");
		}
		if ($Line === false)
			echo '(not available)</span></li></ul></div>';

		// Display device status
		echo '<hr/><div class="month" style="background: black"><ul><li>Device status at ';
		$Arr = explode("_", $DevStatus[$DateStartStatusIdx], 4);
		echo preg_replace('~[hm]~',':',substr($Arr[1],0,-1));
		echo '</li></ul></div>';
		echo '<div style="width:100%">';

		$FreezeThresholdCnf = -1000;
		$StatusTxt = file_get_contents($DevStatus[$DateStartStatusIdx]);
		$Line = strtok($StatusTxt, "\r\n");
		while ($Line !== false)
		{
			if (strpos($Line, "Firmware") !== false)	echo $Line.'<br>';
			if (strpos($Line, "Configuration:") !== false)
			{
				echo $Line.'<br>';
				$Arr = explode(",", $Line);
				foreach($Arr as $ConfigData)
				{
					$Arr1 = explode("=", $ConfigData);
					if (($Arr1[0] == "FT") && ($Arr1[1] != "N/A"))
					{
						$FreezeThresholdCnf = intval(round((10*floatval($Arr1[1])), 0));
						break;
					}
				}
			}
			if (strpos($Line, "Signal quality:") !== false)	echo $Line.'<br>';
			if (strpos($Line, "Battery Voltage:") !== false) {echo $Line; break;}
			$Line = strtok("\r\n");
		}
		echo '</div>';

		// Display device settings
		echo '<hr/><div class="month" style="background: black"><ul><li>Settings - hold +/- to accelerate - press upload when finish!</li></ul></div>';
		if ($FreezeThresholdCnf != -1000)
		{
			if (($ConfigTxt = file_get_contents($PathDevice."/firmware/cnf.txt")))
			{
				$Line = strtok($ConfigTxt, "\r\n");
				while ($Line !== false)
				{
					if (strpos($Line, "A_FreezeThreshold") !== false)
					{
						$Arr = explode("=", $Line);
						$FreezeThresholdCnf = intval($Arr[1]);
						break;
					}
					$Line = strtok("\r\n");
				}
			}
			echo '<script type="text/javascript">updatefreezetempinit('.$FreezeThresholdCnf.');</script>';
			$Temp = $FreezeThresholdCnf;		$Sign = "";		if ($Temp < 0) {$Sign = "-"; $Temp = -$Temp;};
			echo '<div class="settings"><ul><li style="width: 15.0%"><img class="icons" src="icons/ifreeze.gif"></li>';
			echo '<li style="width: 35.0%;color: white"><p id="TempFreeze">'.$Sign.intval($Temp/10).'.'.intval($Temp%10).'°C</p></li>';
			echo '<li style="width: 15.0%"><input type="image" src="icons/iminus.gif" draggable="false" onclick="startdec()" onmousedown="startdecpress()" ontouchstart="startdecpress()"></li>';
			echo '<li style="width: 20.0%"><div><input type="image" src="icons/iplus.gif" draggable="false" onclick="startinc()" onmousedown="startincpress()" ontouchstart="startincpress()"></div></li>';
			echo '<li style="width: 15.0%"><form method="post" action="displays.php"><input type="hidden" id="freezetempid" name="freezetemp" value="'.$FreezeThresholdCnf.'"><input type="image" src="icons/iupload.gif"></form></li>';
			echo '</ul></div>';
		}
	}	
	else
		echo '<div class="month" style="background: black"><ul><li>No data for selected period</li></ul></div>';
}
else
	echo '<br><br><br><hr/><div class="month" style="background: red"><ul><li><a href="index.html">Wrong user/password. Click to login again.</a></li></ul></div><hr/>';

?>
</body>
<script>
  function DisplayDevicesMap() {
  	var x = document.getElementById("DevicesMap");
	var y = document.getElementById("DevicesMapDelimiter");
  	if (x.style.display === "none"){
		x.style.display = "block";
		y.style.display = "block";
		map.setTarget(x);
		map.updateSize();
		<?php
			if (isset($_SESSION['device']))
			{
				$GpsPosTmp = $DevicesGps[$DevicesList->Devices[$_SESSION['device']]->DeviceId]['GPS'];
				if ($GpsPosTmp == "N/A")	unset($GpsPosTmp);
			}
			if (isset($GpsPosTmp))	echo "map.getView().setCenter(ol.proj.transform([$GpsPosTmp], 'EPSG:4326', 'EPSG:3857')); map.getView().setZoom(8);";
			else					echo 'map.getView().fit(vectorLayer.getSource().getExtent(), {size: map.getSize(), padding:[100,100,100,100], maxZoom: 10});'
		?>
	} 	
  	else{
		x.style.display = "none";
		y.style.display = "none";
		map.setTarget(none);
	}    							
  }
</script>
</html>