<!DOCTYPE html>
<html>
<head>
<link rel="stylesheet" href="style.css">
<style>
th, td {
  padding: 5px;
}
</style>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.6.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.1/Chart.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels@0.7.0"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/chartjs-plugin-annotation/0.5.7/chartjs-plugin-annotation.min.js"></script> 
<link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700" rel="stylesheet">
</head>

<body>
<?php

$DevicesList = json_decode(file_get_contents("Users/Relu.json", true));

echo '<table border=0>';
echo '<tr><td>&nbsp</td><td><b>Date</td><td><b>Signal</td><td><b>BAT</td><td><b>IR</td><td><b>MOT1</td><td><b>MOT2</td><td><b>CAM</td></tr>';	
for($I=0; $I<count($DevicesList->Devices); $I++)
{
	$Device=$DevicesList->Devices[$I];
	$StatusFiles = scandir($Device->DeviceId.'/status/', SCANDIR_SORT_DESCENDING);
	$NewestStatusFile = $StatusFiles[0];

	$File = pathinfo($NewestStatusFile, PATHINFO_FILENAME);
	$Arr = explode("_", $File, 3);
	$DateStr = $Arr[0];
	$TimeStr = $Arr[1];

	echo '<tr><td><span class="devfont" style="border: 2px; border-radius: 4px;">'.$Device->DeviceName.'</span></td>';
	echo '<td><b>'.$DateStr.'</b> '.$TimeStr.'</td>';
			
	$StatusTxt = file_get_contents($Device->DeviceId.'/status/'.$NewestStatusFile);
	$Line = strtok($StatusTxt, "\r\n");
	$Sig = 0; $Ir = 0; $M1 = 0; $M2 = 0; $Cam = 0; 
	while ($Line !== false)
	{
		if (strpos($Line, "Signal quality:") !== false)
			{$ResA = explode('(', $Line);	 $ResA = explode(')', $ResA[1]);	echo'<td>'.$ResA[0].'</td>';	$Sig = 1;}
		if (strpos($Line, "Battery Voltage:") !== false)
			{if ($Sig == 0)	echo '<td>n/a</td>';	$ResA = explode(':', $Line);	 echo'<td>'.substr($ResA[1],1).'</td>';}
		if (strpos($Line, "IR quality:") !== false)
			{$ResA = explode(':', $Line);	 $String = substr($ResA[1],1); echo'<td>'.$String.'</td>'; $Ir = 1;}
		if (strpos($Line, "Motor1 status:") !== false)
			{$ResA = explode(':', $Line);	 $String = substr($ResA[1],1); echo'<td>'; if ($String != 'ok') echo '<b><font color="red">'; echo $String.'</td>'; $M1 = 1;}
		if (strpos($Line, "Motor2 status:") !== false)
			{$ResA = explode(':', $Line);	 $String = substr($ResA[1],1); echo'<td>'.$String.'</td>'; $M2 = 1;}
		if (strpos($Line, "Camera status:") !== false)
			{$ResA = explode(':', $Line);	 $String = substr($ResA[1],1); echo'<td>'.$String.'</td>'; $Cam = 1; break;}		
		$Line = strtok("\r\n");
	}
	if ($Ir == 0)	echo '<td>n/a</td>';
	if ($M1 == 0)	echo '<td>n/a</td>';
	if ($M2 == 0)	echo '<td>n/a</td>';
	if ($Cam == 0)	echo '<td>n/a</td>';
	echo '</tr>';
}
echo '</table>';
?>

</body>
</html>